/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.enums;

import csbase.client.util.gui.log.LogPanel;

public enum FontType {
    SERIF("serif"),
    SAN_SERIF("sanserif"),
    VERDANA("verdana"),
    MONOSPACED("monospaced");

    private final String typeName;

    public final String getTypeName() {
        return this.typeName;
    }

    public final String getLabel() {
        String key = String.format("%s.%s", ((Object)((Object)this)).getClass().getSimpleName(), this.name());
        return LogPanel.getString(key, new Object[0]);
    }

    private FontType(String typeName) {
        this.typeName = typeName;
    }

    public static FontType getFontTypeByName(String name) {
        for (FontType tp : FontType.values()) {
            if (!tp.getTypeName().equals(name)) continue;
            return tp;
        }
        return null;
    }
}

