/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.util.gui.AlgorithmFilterParamPanel;
import csbase.client.util.gui.AlgorithmFilterParamPanelListener;
import csbase.client.util.gui.AlgorithmInfoFilterOperator;
import csbase.client.util.gui.FilterableComboModel;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class FilterableListPanel
extends JPanel {
    private AlgorithmFilterParamPanel filterParamPanel;
    private JList jlist;
    private AlgorithmItemFilter filter = new AlgorithmItemFilter();

    public FilterableListPanel(Vector<AlgorithmListItem> list) {
        this.jlist = new JList();
        Vector<Object> oList = new Vector<Object>(list);
        FilterableComboModel model = new FilterableComboModel(oList, this.filter);
        this.jlist.setModel(model);
        this.filterParamPanel = new AlgorithmFilterParamPanel();
        this.filterParamPanel.addListener(new AlgorithmFilterParamPanelListener(){

            @Override
            public void panelChanged(boolean ignoreCase, boolean useRegex, boolean showSimple, boolean showFlow, String text) {
                AlgorithmInfoFilterOperator operator = new AlgorithmInfoFilterOperator(ignoreCase, useRegex, showSimple, showFlow, text);
                FilterableListPanel.this.filter.setParamters(operator);
                FilterableComboModel model = (FilterableComboModel)FilterableListPanel.this.jlist.getModel();
                model.filter();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.filterParamPanel, "North");
        this.add((Component)new JScrollPane(this.jlist, 22, 32), "Center");
        this.filterParamPanel.updateState();
    }

    public JList getList() {
        return this.jlist;
    }

    private class AlgorithmItemFilter
    extends FilterableComboModel.Filter {
        AlgorithmInfoFilterOperator operator;

        private AlgorithmItemFilter() {
        }

        public void setParamters(AlgorithmInfoFilterOperator operator) {
            this.operator = operator;
        }

        @Override
        public boolean accept(Object object) {
            AlgorithmInfo info = ((AlgorithmListItem)object).getItem();
            return this.operator.accept(info);
        }

        @Override
        public boolean isEnabled() {
            return this.operator != null;
        }
    }
}

