/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JSplitPane;

public class JMultiSplitPane
extends JSplitPane {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;

    public JMultiSplitPane(int orientation, boolean continuousLayout, Component ... cs) {
        this(orientation, continuousLayout, Arrays.asList(cs), 0);
    }

    public JMultiSplitPane(int orientation, boolean continuousLayout, List<Component> cs) {
        this(orientation, continuousLayout, cs, 0);
    }

    public JMultiSplitPane(int orientation, boolean continuousLayout, List<Component> cs, int offset) {
        super(orientation, continuousLayout, null, null);
        if (cs.size() < 2) {
            throw new IllegalArgumentException("cs deve conter ao menos dois componentes.");
        }
        this.addComponents(orientation, continuousLayout, cs, offset);
    }

    private void addComponents(int orientation, boolean continuousLayout, List<Component> cs, int offset) {
        this.setLeftComponent(cs.get(offset));
        int next = offset + 1;
        if (next == cs.size() - 1) {
            this.setRightComponent(cs.get(next));
        } else {
            JMultiSplitPane nextPane = new JMultiSplitPane(orientation, continuousLayout, cs, next);
            this.setRightComponent(nextPane);
        }
    }

    @Override
    public void setContinuousLayout(boolean newContinuousLayout) {
        super.setContinuousLayout(newContinuousLayout);
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMultiSplitPane)) continue;
            ((JSplitPane)JSplitPane.class.cast(c)).setContinuousLayout(newContinuousLayout);
        }
    }

    @Override
    public void setDividerSize(int newSize) {
        super.setDividerSize(newSize);
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMultiSplitPane)) continue;
            ((JSplitPane)JSplitPane.class.cast(c)).setDividerSize(newSize);
        }
    }

    @Override
    public void setOneTouchExpandable(boolean newValue) {
        super.setOneTouchExpandable(newValue);
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMultiSplitPane)) continue;
            ((JSplitPane)JSplitPane.class.cast(c)).setOneTouchExpandable(newValue);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMultiSplitPane)) continue;
            ((JSplitPane)JSplitPane.class.cast(c)).setOrientation(orientation);
        }
    }

    @Override
    public void setResizeWeight(double value) {
        super.setResizeWeight(value);
        for (Component c : this.getComponents()) {
            if (!(c instanceof JMultiSplitPane)) continue;
            ((JSplitPane)JSplitPane.class.cast(c)).setResizeWeight(value);
        }
    }
}

