/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleAlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.configurator.FlowAlgorithmConfiguratorView;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.exception.BugException;
import csbase.exception.PermissionException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class AlgorithmConfiguratorFactory {
    private static AlgorithmConfiguratorFactory instance;

    private AlgorithmConfiguratorFactory() {
    }

    public static AlgorithmConfiguratorFactory getInstance() {
        if (instance == null) {
            instance = new AlgorithmConfiguratorFactory();
        }
        return instance;
    }

    public AlgorithmConfiguratorView createReportView(Window owner, AlgorithmConfigurator configurator) {
        if (owner == null) {
            throw new IllegalArgumentException("O par\u00e2metro owner est\u00e1 nulo.");
        }
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        return this.createView(owner, configurator, ParameterView.Mode.REPORT, ValidationMode.FULL);
    }

    public AlgorithmConfiguratorView createConfigurationView(Window owner, final AlgorithmVersionInfo version, ValidationMode defaultValidationMode) {
        if (owner == null) {
            throw new IllegalArgumentException("O par\u00e2metro owner est\u00e1 nulo.");
        }
        if (version == null) {
            throw new IllegalArgumentException("O par\u00e2metro version est\u00e1 nulo.");
        }
        RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

            protected void performTask() throws Exception {
                String algorithmName = version.getInfo().getName();
                AlgorithmVersionId algorithmVersionId = version.getId();
                AlgorithmConfigurator algorithmConfigurator = ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(algorithmName, algorithmVersionId);
                this.setResult(algorithmConfigurator);
            }
        };
        if (task.execute(owner, this.getString("reading_configurator_title", new Object[0]), this.getString("reading_configurator", new Object[0]))) {
            AlgorithmConfigurator algorithmConfigurator = (AlgorithmConfigurator)task.getResult();
            return this.createView(owner, algorithmConfigurator, ParameterView.Mode.CONFIGURATION, defaultValidationMode);
        }
        return null;
    }

    private AlgorithmConfiguratorView createView(Window owner, AlgorithmConfigurator algorithmConfigurator, ParameterView.Mode mode, ValidationMode defaultValidationMode) {
        AlgorithmConfiguratorView configuratorView;
        block8: {
            if (mode == null) {
                throw new IllegalArgumentException("O par\u00e2metro mode est\u00e1 nulo.");
            }
            if (algorithmConfigurator == null) {
                throw new IllegalArgumentException("O par\u00e2metro algorithmConfigurator est\u00e1 nulo.");
            }
            configuratorView = null;
            try {
                AlgorithmConfigurator.ConfiguratorType configuratorType = algorithmConfigurator.getConfiguratorType();
                switch (configuratorType) {
                    case SIMPLE: {
                        SimpleAlgorithmConfigurator simpleAlgorithmConfigurator = (SimpleAlgorithmConfigurator)algorithmConfigurator;
                        configuratorView = new SimpleAlgorithmConfiguratorView(owner, simpleAlgorithmConfigurator, mode, defaultValidationMode);
                        break;
                    }
                    case FLOW: {
                        FlowAlgorithmConfigurator flowAlgorithmConfigurator = (FlowAlgorithmConfigurator)algorithmConfigurator;
                        configuratorView = new FlowAlgorithmConfiguratorView(owner, flowAlgorithmConfigurator, mode, defaultValidationMode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Tipo de configurador n\u00e3o conhecido: " + configuratorType);
                    }
                }
            }
            catch (ClientException e) {
                if (e.getCause() instanceof PermissionException) break block8;
                throw new BugException(this.getString("error_creating_configurator_view", algorithmConfigurator.getAlgorithmName()), (Throwable)e);
            }
        }
        return configuratorView;
    }

    private String getString(String suffixKey, Object ... arguments) {
        return MessageFormat.format(LNG.get((String)(AlgorithmConfiguratorFactory.class.getName() + "." + suffixKey)), arguments);
    }
}

