/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.preferenceviewer;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.preferenceviewer.PreferenceViewer;
import csbase.client.applications.preferenceviewer.tree.PreferenceTreePanel;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.util.PreferencesUtil;
import csbase.client.util.gui.CardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import tecgraf.javautils.gui.GBC;

public class PreferencePanel
extends JPanel {
    private PreferenceViewer app;
    private JButton restore;
    private CardPanel valuesPanel;
    private PreferenceTreePanel treePanel;
    private JCheckBox saveLocalPreferences;
    private Set<PreferenceCategory> modifiedCategories;

    public PreferencePanel(PreferenceViewer app) {
        super(new GridBagLayout());
        this.app = app;
        this.restore = this.createRestoreButton();
        this.saveLocalPreferences = this.createSaveLocalPreferencesCheckBox();
        this.valuesPanel = new CardPanel(true, true);
        this.treePanel = this.createTreePanel();
        this.modifiedCategories = new HashSet<PreferenceCategory>();
        this.buildInterface(true);
    }

    public void rebuidInterface(PreferenceCategory pc) {
        this.removeAll();
        this.treePanel.rebuildTree(pc);
        this.saveLocalPreferences.setVisible(pc.isCopy());
        boolean hasChildren = !pc.getCategories().isEmpty();
        this.buildInterface(hasChildren);
        this.updateUI();
    }

    public Set<PreferenceCategory> getModifiedCategories() {
        return this.modifiedCategories;
    }

    public void addModifiedCategory(PreferenceCategory pc) {
        this.modifiedCategories.add(pc);
    }

    public void showPreferencePanel(PreferenceCategory pc) {
        if (!this.valuesPanel.has(pc.toString())) {
            this.addPreferencePanel(pc, false);
        }
        this.valuesPanel.show(pc.toString());
        ApplicationFrame frame = this.app.getApplicationFrame();
        Dimension preferred = frame.getPreferredSize();
        Dimension current = frame.getSize();
        if (preferred.width > current.width) {
            current.width = preferred.width;
        }
        if (preferred.height > current.height) {
            current.height = preferred.height;
        }
        frame.setSize(current);
    }

    public void removeAllListeners() {
        this.treePanel.removeAllListeners();
    }

    JButton getRestoreButton() {
        return this.restore;
    }

    boolean saveLocalPreferences() {
        return this.saveLocalPreferences.isSelected();
    }

    private void buildInterface(boolean showTree) {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)new JScrollPane(this.valuesPanel), new GBC(0, 0).both().insets(5));
        rightPanel.add((Component)new JLabel(), new GBC(0, 1).horizontal());
        rightPanel.add((Component)this.createInfPanel(), new GBC(0, 2).horizontal().insets(5));
        if (showTree) {
            JSplitPane mainPanel = new JSplitPane(1);
            mainPanel.add(this.treePanel);
            mainPanel.add(rightPanel);
            mainPanel.setOneTouchExpandable(true);
            this.add((Component)mainPanel, new GBC(0, 0).both());
        } else {
            this.add((Component)rightPanel, new GBC(0, 0).both());
        }
    }

    private void addPreferencePanel(PreferenceCategory pc, boolean showDefaultValues) {
        JPanel titlePanel = this.createTitlePanel(pc);
        JPanel prefsPanel = PreferencesUtil.createPreferencePanel(pc, showDefaultValues);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)titlePanel, new GBC(0, 0).horizontal());
        panel.add((Component)new JSeparator(0), new GBC(0, 1).horizontal().left(10).right(10));
        panel.add((Component)prefsPanel, new GBC(0, 2).both());
        this.valuesPanel.add((Component)panel, pc.toString());
    }

    private PreferenceTreePanel createTreePanel() {
        PreferenceTreePanel panel = new PreferenceTreePanel(this, this.app);
        panel.defaultSelection();
        return panel;
    }

    private JPanel createTitlePanel(PreferenceCategory pc) {
        JLabel label = new JLabel(pc.getLabel());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GBC(0, 0).top(10).left(10).bottom(5).west());
        panel.add((Component)new JLabel(), new GBC(1, 0).horizontal());
        return panel;
    }

    private JPanel createInfPanel() {
        JPanel infPanel = new JPanel(new GridBagLayout());
        infPanel.add((Component)this.saveLocalPreferences, new GBC(0, 0).horizontal());
        infPanel.add((Component)new JLabel(), new GBC(1, 0).horizontal());
        infPanel.add((Component)this.restore, new GBC(2, 0));
        return infPanel;
    }

    private JButton createRestoreButton() {
        JButton restore = new JButton(this.app.getString("button.restore"));
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceCategory lastSelected = PreferencePanel.this.treePanel.getLastSelected();
                PreferencePanel.this.valuesPanel.remove(lastSelected.toString());
                PreferencePanel.this.addPreferencePanel(lastSelected, true);
                PreferencePanel.this.showPreferencePanel(lastSelected);
                PreferencePanel.this.addModifiedCategory(lastSelected);
                PreferencePanel.this.updateUI();
            }
        });
        return restore;
    }

    private JCheckBox createSaveLocalPreferencesCheckBox() {
        JCheckBox checkBox = new JCheckBox(this.app.getString("save.as.default"));
        checkBox.setFont(new Font("SansSerif", 0, 13));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencePanel.this.addModifiedCategory(PreferencePanel.this.treePanel.getLastSelected());
            }
        });
        return checkBox;
    }
}

