/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.LoginAsDesktopAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.PreLoginData;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ServerEntryPoint;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;

class LoginAsTask
extends RemoteTask<Void> {
    private final LoginAsDesktopAction action;

    @Override
    protected void handleError(Exception error) {
        String message = error.getMessage();
        this.action.showErrorMessage(message);
    }

    @Override
    protected void handleServerError(CSBaseRuntimeException cserror) {
        String message = cserror.getMessage();
        this.action.showErrorMessage(message);
    }

    public void performTask() throws Exception {
        ServerEntryPoint serverEntryPoint = ClientRemoteLocator.server;
        Locale locale = LNG.getLocale();
        ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
        String userLogin = clientRemoteMonitor.getLogin();
        HashMap<String, String> attributes = serverEntryPoint.getSessionAttributes((Object)userLogin);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put("realUser", userLogin);
        PreLoginData preLoginData = serverEntryPoint.preLogin(this.action.getNewLogin(), "", locale, attributes);
        String urlStr = serverEntryPoint.generateSystemURL(preLoginData.getToken(), locale, this.action.getSystemName());
        URL url = new URL(urlStr);
        ExternalResources extResources = ExternalResources.getInstance();
        extResources.showDocument(url);
    }

    public LoginAsTask(LoginAsDesktopAction action) {
        this.action = action;
    }
}

