/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.commandtable;

import csbase.client.facilities.commandtable.CommandImages;
import csbase.client.facilities.commandtable.CommandStatusCellData;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import javax.swing.Icon;
import tecgraf.javautils.core.lng.LNG;

public class CommandStatusHelper {
    public static CommandStatusCellData createCellData(CommandInfo commandInfo) {
        Icon icon = CommandStatusHelper.getImage(commandInfo);
        String tooltip = CommandStatusHelper.getDescription(commandInfo);
        return new CommandStatusCellData(commandInfo, icon, tooltip);
    }

    public static String getDescription(CommandInfo commandInfo) {
        CommandStatus status = commandInfo.getStatus();
        if (status == null) {
            return "";
        }
        if (status == CommandStatus.FINISHED) {
            CommandFinalizationType finalizationType = commandInfo.getFinalizationType();
            String description = CommandStatusHelper.getDescriptionFromFinalizationType(finalizationType);
            if (commandInfo.hasWarnings()) {
                description = description + " " + CommandStatusHelper.getMessage("status_finished_warning");
            }
            return description;
        }
        if (commandInfo.isValid()) {
            if (commandInfo.isQueued()) {
                return CommandStatusHelper.getMessage("status_queued");
            }
            return CommandStatusHelper.getDescriptionFromCommandStatus(status);
        }
        return CommandStatusHelper.getMessage("status_disconnected");
    }

    public static String getDescriptionFromCommandStatus(CommandStatus status) {
        switch (status) {
            case SCHEDULED: {
                return CommandStatusHelper.getMessage("status_scheduled");
            }
            case INIT: {
                return CommandStatusHelper.getMessage("status_init");
            }
            case UPLOADING: {
                return CommandStatusHelper.getMessage("status_uploading");
            }
            case EXECUTING: {
                return CommandStatusHelper.getMessage("status_executing");
            }
            case DOWNLOADING: {
                return CommandStatusHelper.getMessage("status_downloading");
            }
            case SYSTEM_FAILURE: {
                return CommandStatusHelper.getMessage("system_failure");
            }
            case FINISHED: {
                return CommandStatusHelper.getMessage("status_finished");
            }
        }
        return "";
    }

    public static String getDescriptionFromFinalizationType(CommandFinalizationType finalizationType) {
        if (null == finalizationType) {
            return CommandStatusHelper.getMessage("status_finished");
        }
        switch (finalizationType) {
            case UNKNOWN: {
                return CommandStatusHelper.getMessage("status_finished_unknown");
            }
            case EXECUTION_ERROR: {
                return CommandStatusHelper.getMessage("status_finished_error");
            }
            case END: {
                return CommandStatusHelper.getMessage("status_finished_end");
            }
            case SUCCESS: {
                return CommandStatusHelper.getMessage("status_finished_success");
            }
            case FAILED: {
                return CommandStatusHelper.getMessage("status_finished_failed");
            }
            case KILLED: {
                return CommandStatusHelper.getMessage("status_finished_killed");
            }
            case LOST: {
                return CommandStatusHelper.getMessage("status_finished_lost");
            }
            case NO_EXIT_CODE: {
                return CommandStatusHelper.getMessage("status_finished_no_code");
            }
        }
        return CommandStatusHelper.getMessage("status_finished");
    }

    public static Icon getImage(CommandInfo commandInfo) {
        CommandStatus status = commandInfo.getStatus();
        if (status == null) {
            return CommandImages.ICON_CMD_NONE;
        }
        if (status == CommandStatus.FINISHED) {
            CommandFinalizationType finalizationType = commandInfo.getFinalizationType();
            if (finalizationType == CommandFinalizationType.SUCCESS && commandInfo.getFinalizationInfo().hasWarnings()) {
                return CommandImages.ICON_CMD_WARNING;
            }
            return CommandStatusHelper.getImageFromFinalizationType(finalizationType);
        }
        if (commandInfo.isValid()) {
            if (commandInfo.isQueued()) {
                return CommandImages.ICON_CMD_QUEUED;
            }
            return CommandStatusHelper.getImageFromCommandStatus(status);
        }
        return CommandImages.ICON_CMD_DISCONNECTED;
    }

    public static Icon getImageFromCommandStatus(CommandStatus status) {
        switch (status) {
            case DOWNLOADING: {
                return CommandImages.ICON_CMD_DOWNLOADING;
            }
            case EXECUTING: {
                return CommandImages.ICON_CMD_EXECUTING_ANIMATED;
            }
            case INIT: {
                return CommandImages.ICON_CMD_INIT;
            }
            case SCHEDULED: {
                return CommandImages.ICON_CMD_SCHEDULED;
            }
            case UPLOADING: {
                return CommandImages.ICON_CMD_UPLOADING;
            }
            case FINISHED: {
                return CommandImages.ICON_CMD_END;
            }
            case SYSTEM_FAILURE: {
                return CommandImages.ICON_CMD_SYSTEM_FAILURE;
            }
        }
        return CommandImages.ICON_CMD_NONE;
    }

    public static Icon getImageFromFinalizationType(CommandFinalizationType finalizationType) {
        if (null == finalizationType) {
            return CommandImages.ICON_CMD_END;
        }
        switch (finalizationType) {
            case END: {
                return CommandImages.ICON_CMD_END;
            }
            case EXECUTION_ERROR: {
                return CommandImages.ICON_CMD_ERROR;
            }
            case FAILED: {
                return CommandImages.ICON_CMD_FAIL;
            }
            case KILLED: {
                return CommandImages.ICON_CMD_KILLED;
            }
            case LOST: {
                return CommandImages.ICON_CMD_LOST;
            }
            case SUCCESS: {
                return CommandImages.ICON_CMD_SUCCESS;
            }
            case UNKNOWN: {
                return CommandImages.ICON_CMD_UNKNOWN;
            }
            case NO_EXIT_CODE: {
                return CommandImages.ICON_CMD_NO_CODE;
            }
        }
        return CommandImages.ICON_CMD_NONE;
    }

    private static String getMessage(String keySuffix) {
        return LNG.get((String)(CommandStatusHelper.class.getSimpleName() + "." + keySuffix));
    }
}

