/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.remotepanel;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.ChangeRemoteDirectoryAction;
import csbase.client.applications.filetransferclient.actions.HomeRemoteAction;
import csbase.client.applications.filetransferclient.actions.RefreshRemoteAction;
import csbase.client.applications.filetransferclient.actions.RootRemoteAction;
import csbase.client.applications.filetransferclient.actions.UpRemoteDirectoryAction;
import csbase.client.applications.filetransferclient.panels.core.FileTransferClientPanel;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.client.applications.filetransferclient.panels.remotepanel.RemoteTableModel;
import csbase.client.applications.filetransferclient.panels.remotepanel.RemoteTableRenderer;
import csbase.client.applications.filetransferclient.panels.remotepanel.RemoteTypeComparator;
import csbase.logic.ClientProjectFile;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferElement;
import csbase.logic.filetransferservice.FileTransferProtocol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.SortableTable;

public class FileTransferClientRemotePanel
extends FileTransferClientPanel {
    public static final String ROOT_REMOTE_PATH = "/";
    private String remoteDirectory;
    private final SortableTable remoteTable = new SortableTable();
    private final JTextField remoteDirText = new JTextField();
    private final JTextField serverText = new JTextField(30);
    private final JTextField userText = new JTextField(30);
    private boolean dotFiltered = true;
    private final HomeRemoteAction homeAction;
    private final JToolBar toolBar = new JToolBar(0);

    public boolean isDotFiltered() {
        return this.dotFiltered;
    }

    public void setDotFiltered(boolean dotFiltered) {
        this.dotFiltered = dotFiltered;
        this.refresh();
    }

    private JPanel buildInfoPanel() {
        this.remoteDirText.setEditable(false);
        this.userText.setEditable(false);
        this.serverText.setEditable(false);
        JLabel remoteDirLabel = new JLabel();
        remoteDirLabel.setText(this.getString("remote.directory.label"));
        JLabel userLabel = new JLabel();
        userLabel.setText(this.getString("remote.user.label"));
        JLabel serverLabel = new JLabel();
        serverLabel.setText(this.getString("remote.server.label"));
        JPanel infoPanel = new JPanel();
        JComponent[][] cmps = new JComponent[][]{{userLabel, this.userText}, {serverLabel, this.serverText}, {remoteDirLabel, this.remoteDirText}};
        GUIUtils.mountBasicGridPanel((JPanel)infoPanel, (JComponent[][])cmps);
        String title = this.getString("frame");
        JLabel remoteLabel = new JLabel();
        remoteLabel.setIcon(FileTransferClientUI.REMOTE_ICON);
        remoteLabel.setText(title);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)remoteLabel, new GBC(0, 0).none().west().insets(0, 0, 20, 0));
        panel.add((Component)infoPanel, new GBC(0, 1).both());
        return panel;
    }

    private void mountToolBar() {
        FileTransferClient application = this.getApplication();
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.homeAction);
        this.toolBar.addSeparator();
        this.toolBar.add(new RootRemoteAction(application));
        this.toolBar.add(new ChangeRemoteDirectoryAction(application));
        this.toolBar.add(new UpRemoteDirectoryAction(application));
        this.toolBar.add(new JPanel());
        this.toolBar.add(new RefreshRemoteAction(application));
    }

    private void doubleClickedOnTable() {
        List<FileTransferElement> sels = this.getSelectedElements();
        if (sels.size() != 1) {
            return;
        }
        FileTransferElement selected = sels.get(0);
        if (selected == null || selected.isLink()) {
            return;
        }
        String elementName = selected.getName();
        if (selected.isDirectory()) {
            String remoteDir = this.getRemoteDirectory();
            String newDir = remoteDir + ROOT_REMOTE_PATH + elementName;
            this.setRemoteDirectory(newDir);
        } else {
            String fmt;
            String question;
            String title;
            FileTransferClient application = this.getApplication();
            String remoteDir = this.getRemoteDirectory();
            String remotePath = remoteDir + ROOT_REMOTE_PATH + elementName;
            ApplicationFrame frame = application.getApplicationFrame();
            if (StandardDialogs.showYesNoDialog((Component)frame, (String)(title = this.getString("download.confirm.title")), (Object)(question = String.format(fmt = this.getString("download.confirm.message"), remotePath))) != 0) {
                return;
            }
            FileTransferClientLocalPanel localPanel = application.getLocalPanel();
            ClientProjectFile localDirectory = localPanel.getLocalDirectory();
            String localDir = FileTransferClientUI.pathToString(localDirectory);
            String localPath = FileTransferClientUI.isEmptyString(localDir) ? elementName : localDir + ROOT_REMOTE_PATH + elementName;
            String lPath = localPath;
            while (lPath.startsWith(ROOT_REMOTE_PATH)) {
                lPath = lPath.substring(1);
            }
            String[] localFilePath = lPath.split(ROOT_REMOTE_PATH);
            FileTransferProxy serviceProxy = application.getServiceProxy();
            FileTransferConnection connection = application.getConnection();
            long size = selected.getSizeBytes();
            serviceProxy.download(connection, remotePath, localFilePath, size);
            localPanel.refresh();
            FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
            queuePanel.refresh();
        }
    }

    public final String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public final List<FileTransferElement> getSelectedElements() {
        int[] sels = this.remoteTable.getSelectedRows();
        if (sels == null || sels.length == 0) {
            return null;
        }
        RemoteTableModel model = (RemoteTableModel)this.remoteTable.getModel();
        List<FileTransferElement> modelList = model.getFileList();
        ArrayList<FileTransferElement> elems = new ArrayList<FileTransferElement>();
        for (int sel : sels) {
            int modelSel = this.remoteTable.convertRowIndexToModel(sel);
            FileTransferElement file = modelList.get(modelSel);
            elems.add(file);
        }
        Collections.unmodifiableList(elems);
        return elems;
    }

    public final boolean isRootDirectory(String remoteDir) {
        if (remoteDir == null) {
            String err = "remoteDir cannot be null";
            throw new IllegalArgumentException("remoteDir cannot be null");
        }
        return remoteDir.trim().equals(ROOT_REMOTE_PATH);
    }

    private void mountPanel() {
        this.setLayout(new BorderLayout());
        JPanel infoPanel = this.buildInfoPanel();
        this.mountToolBar();
        JScrollPane scrollTable = new JScrollPane((Component)this.remoteTable);
        String[] cNames = new String[]{this.getString("fd.column"), this.getString("name.column"), this.getString("size.column")};
        RemoteTableModel model = new RemoteTableModel(cNames);
        this.remoteTable.setModel((TableModel)model);
        this.remoteTable.setComparator(0, (Comparator)new RemoteTypeComparator());
        this.remoteTable.setNoSortStateEnabled(true);
        this.remoteTable.setSelectionMode(2);
        this.remoteTable.sort(0, SortOrder.ASCENDING);
        RemoteTableRenderer renderer = new RemoteTableRenderer();
        this.remoteTable.setDefaultRenderer(FileTransferElement.class, (TableCellRenderer)renderer);
        this.remoteTable.setDefaultRenderer(Long.class, (TableCellRenderer)renderer);
        this.remoteTable.setDefaultRenderer(String.class, (TableCellRenderer)renderer);
        this.remoteTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileTransferClientRemotePanel.this.doubleClickedOnTable();
                }
            }
        });
        TableColumnModel colModel = this.remoteTable.getColumnModel();
        this.remoteTable.setAutoResizeMode(3);
        TableColumn c0 = colModel.getColumn(0);
        TableColumn c1 = colModel.getColumn(1);
        TableColumn c2 = colModel.getColumn(2);
        c0.setPreferredWidth(10);
        c1.setPreferredWidth(150);
        c2.setPreferredWidth(40);
        this.add((Component)infoPanel, "North");
        this.add((Component)scrollTable, "Center");
        this.add((Component)this.toolBar, "South");
        FileTransferClientUI.setEtchedBorder(this);
    }

    public final void refresh() {
        FileTransferClient aaplication = this.getApplication();
        FileTransferConnection connection = aaplication.getConnection();
        RemoteTableModel model = (RemoteTableModel)this.remoteTable.getModel();
        if (connection == null) {
            model.setFileList(null);
            return;
        }
        FileTransferProxy serviceProxy = aaplication.getServiceProxy();
        List<FileTransferElement> files = serviceProxy.listContent(connection, this.remoteDirectory);
        if (files == null) {
            model.setFileList(null);
            return;
        }
        ArrayList<FileTransferElement> filteredFiles = new ArrayList<FileTransferElement>();
        for (FileTransferElement file : files) {
            if (!this.filterAllows(file)) continue;
            filteredFiles.add(file);
        }
        model.setFileList(filteredFiles);
    }

    private boolean filterAllows(FileTransferElement element) {
        String name = element.getName();
        return !this.dotFiltered || !name.startsWith(".");
    }

    public final void setConnection(FileTransferConnection connection) {
        if (connection == null) {
            this.serverText.setText(null);
            this.userText.setText(null);
            this.setToolBarEnabled(false);
            return;
        }
        FileTransferProtocol protocol = connection.getProtocol();
        String serverName = connection.getServerName();
        String userName = connection.getUserName();
        this.serverText.setText(serverName + " (" + protocol + ")");
        this.userText.setText(userName);
        this.setToolBarEnabled(true);
        String homePath = connection.getHomePath();
        this.homeAction.setEnabled(homePath != null);
    }

    private void setToolBarEnabled(boolean enabled) {
        Component[] cmps;
        for (Component cmp : cmps = this.toolBar.getComponents()) {
            cmp.setEnabled(enabled);
        }
    }

    public final void setRemoteDirectory(String remoteDirectory) {
        if (remoteDirectory == null) {
            this.remoteDirectory = ROOT_REMOTE_PATH;
        } else {
            String nd = remoteDirectory;
            while (nd.startsWith("//")) {
                nd = nd.substring(1);
            }
            this.remoteDirectory = nd;
        }
        this.remoteDirText.setText(this.remoteDirectory);
        this.refresh();
    }

    public FileTransferClientRemotePanel(FileTransferClient application) {
        super(application);
        this.homeAction = new HomeRemoteAction(application);
        this.mountPanel();
        this.setRemoteDirectory(null);
    }
}

