/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.gui.GBC;

public class ListOutdatedFlowDialog
extends JDialog {
    FlowApplication app;
    JList<OutdatedFlowInfo> jList = new JList();
    JTextArea infoArea = new JTextArea();
    JButton closeButton = new JButton();
    JButton flowEditorButton = new JButton();

    public ListOutdatedFlowDialog(FlowApplication app, Vector<OutdatedFlowInfo> outdatedFlows) {
        this.addEscListener();
        this.app = app;
        Class<?> myClass = this.getClass();
        this.jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(outdatedFlows));
        this.infoArea.setEditable(false);
        JScrollPane listScroll = new JScrollPane(this.jList);
        JScrollPane infoScroll = new JScrollPane(this.infoArea);
        this.setDefaultCloseOperation(2);
        this.closeButton.setText(app.getClassString(myClass, "close.button"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListOutdatedFlowDialog.this.closeDialog();
            }
        });
        this.flowEditorButton.setIcon(ApplicationImages.ICON_FLOW_16);
        this.flowEditorButton.setToolTipText(app.getClassString(myClass, "flow.button.tooltip"));
        this.flowEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListOutdatedFlowDialog.this.openFlowEditor();
            }
        });
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        toolbar.add(this.flowEditorButton);
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.add((Component)listScroll, new GBC(0, 0).insets(0, 0, 0, 6).both().west());
        listPanel.add((Component)toolbar, new GBC(1, 0).insets(0, 6, 0, 0).vertical().northwest());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(app.getClassString(myClass, "outdated.flow.label")), new GBC(0, 0).insets(12, 12, 6, 12).horizontal());
        this.add((Component)listPanel, new GBC(0, 1).insets(6, 12, 12, 12).both().weighty(3.0));
        this.add((Component)new JLabel(app.getClassString(myClass, "detail.label")), new GBC(0, 2).insets(12, 12, 6, 12).horizontal());
        this.add((Component)infoScroll, new GBC(0, 3).insets(6, 12, 6, 12).both().weighty(1.0));
        this.add((Component)this.closeButton, new GBC(0, 4).center().none().insets(6, 12, 12, 12).weighty(1.0));
        this.jList.setPreferredSize(new Dimension(400, 400));
        this.infoArea.setPreferredSize(new Dimension(450, 100));
        Font font = this.infoArea.getFont();
        this.infoArea.setFont(new Font("Courier", font.getStyle(), font.getSize()));
        this.setTitle(app.getClassString(myClass, "title"));
        this.pack();
        this.setLocationRelativeTo(app.getApplicationFrame());
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListOutdatedFlowDialog.this.updateInfoArea();
            }
        });
        if (outdatedFlows.size() > 0) {
            this.jList.setSelectedIndex(0);
        }
    }

    private void openFlowEditor() {
        OutdatedFlowInfo outdatedFlowInfo = this.jList.getSelectedValue();
        if (outdatedFlowInfo == null) {
            return;
        }
        if (this.app.createNewGraph()) {
            this.app.getWorkspace().addNewNode(outdatedFlowInfo.getFlow().getLastVersion());
        }
    }

    protected void closeDialog() {
        this.dispose();
    }

    protected void updateInfoArea() {
        OutdatedFlowInfo flow = this.jList.getSelectedValue();
        if (flow == null) {
            this.infoArea.setText("");
            return;
        }
        if (flow.getError() != null) {
            this.infoArea.setText(flow.getError().getMessage());
        } else {
            String text = "";
            for (int i = 0; i < flow.getLastVersionNodes().size(); ++i) {
                AlgorithmInfo node = flow.getLastVersionNodes().get(i);
                AlgorithmVersionInfo outdatedNode = flow.getOutdatedVersionNodes().get(i);
                text = text + node.getName() + "  " + this.app.getClassString(this.getClass(), "can.be.updated", new String[]{outdatedNode.toString(), node.getLastVersion().toString()}) + "\n";
            }
            this.infoArea.setText(text);
        }
    }

    public void setData(Vector<OutdatedFlowInfo> outdatedFlows) {
        this.jList.setModel(new DefaultComboBoxModel<OutdatedFlowInfo>(outdatedFlows));
    }

    private void addEscListener() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListOutdatedFlowDialog.this.closeDialog();
            }
        };
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        int esc = 27;
        KeyStroke cancelStroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = cancelStroke.toString();
        inputMap.put(cancelStroke, actionMapKey);
        actionMap.put(actionMapKey, cancelAction);
    }
}

