/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import tecgraf.javautils.core.lng.LNG;

public class TestHelpMissing
extends AbstractTest<AlgorithmInfo> {
    public TestHelpMissing(Window window) {
        super(window, LNG.get((String)"TestHelpMissing.task.title"), LNG.get((String)"TestHelpMissing.task.message"));
    }

    @Override
    public List<IResultMessage<AlgorithmInfo>> doTest(AlgorithmInfo algorithmInfo) {
        ArrayList<IResultMessage<AlgorithmInfo>> result = new ArrayList<IResultMessage<AlgorithmInfo>>();
        Vector versions = algorithmInfo.getVersions();
        List missing = versions.stream().filter(v -> v.getDocumentation() == null || v.getDocumentation().size() == 0).collect(Collectors.toList());
        if (missing.size() == 0) {
            ResultMessage<AlgorithmInfo> message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.OK, LNG.get((String)"TestHelpMissing.no.missing"));
            result.add(message);
        } else if (missing.size() == versions.size()) {
            ResultMessage<AlgorithmInfo> message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.ERROR, LNG.get((String)"TestHelpMissing.all.missing"));
            result.add(message);
        } else {
            for (AlgorithmVersionInfo version : missing) {
                ResultMessage<AlgorithmInfo> message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.WARNING, LNG.get((String)"TestHelpMissing.version.missing", (Object[])new String[]{version.toString()}));
                result.add(message);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return LNG.get((String)"TestHelpMissing.name");
    }

    @Override
    public String getDescription() {
        return LNG.get((String)"TestHelpMissing.description");
    }

    @Override
    public Class<AlgorithmInfo> getSubjectClass() {
        return AlgorithmInfo.class;
    }

    @Override
    public String getSubjectName(AlgorithmInfo subject) {
        return subject.getName();
    }
}

