/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.BasicTestDialog;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ReportDialog
extends BasicTestDialog {
    private String TEST = "T";
    private String STATUS = "S";
    private String SUBJECT = "D";
    private JButton closeButton;
    private JCheckBox okFilter;
    private JCheckBox warningFilter;
    private JCheckBox errorFilter;
    private JRadioButton colapsedButton;
    private JRadioButton extendedButton;
    private JComboBox<String> firstSorter;
    private JComboBox<String> secondSorter;
    private JTextPane textArea;
    private final List<ResultInfo<?>> messages;

    public ReportDialog(Map<ITest<?>, ITestResult<?>> testMap, Locale locale, Window parentWindow) {
        super(locale, parentWindow);
        this.mountPanel();
        this.messages = this.convertResult(testMap);
        this.updateTextArea();
        this.setTitle(this.getString("title"));
        this.pack();
        this.setLocationRelativeTo(parentWindow);
    }

    private void updateTextArea() {
        List<ResultInfo<?>> messageSubList = this.filterData(this.messages, this.okFilter.isSelected(), this.warningFilter.isSelected(), this.errorFilter.isSelected());
        messageSubList = this.sortData(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        if (this.colapsedButton.isSelected()) {
            this.printColapsed(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        } else {
            this.printExpanded(messageSubList, (String)this.firstSorter.getSelectedItem(), (String)this.secondSorter.getSelectedItem());
        }
    }

    private void printExpanded(List<ResultInfo<?>> messageSubList, String firstOrder, String secondOrder) {
        String thirdOrder = this.computeThird(firstOrder, secondOrder);
        StringBuilder builder = new StringBuilder("<html>");
        for (ResultInfo<?> info : messageSubList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.TEST, "<i>" + info.test.getName() + "</i>");
            map.put(this.SUBJECT, info.getSubjectName());
            TestStatus status = info.message.getStatus();
            map.put(this.STATUS, this.getFontColor(status) + this.getString(status.toString()) + "</font>");
            builder.append("<strong>");
            builder.append((String)map.get(firstOrder));
            builder.append(" - ");
            builder.append((String)map.get(secondOrder));
            builder.append(" - ");
            builder.append((String)map.get(thirdOrder));
            builder.append("</strong>");
            builder.append(" - ").append(info.message.getMessage());
            builder.append("<br><br>");
        }
        builder.append("</html>");
        this.textArea.setText(builder.toString());
        this.textArea.setCaretPosition(0);
    }

    private void printColapsed(List<ResultInfo<?>> messageSubList, String firstOrder, String secondOrder) {
        String thirdOrder = this.computeThird(firstOrder, secondOrder);
        StringBuilder builder = new StringBuilder("<html>");
        String previousFirst = "";
        String previousSecond = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (ResultInfo<?> info : messageSubList) {
            map.put(this.TEST, "<i>" + info.test.getName() + "</i>");
            map.put(this.SUBJECT, info.getSubjectName());
            TestStatus status = info.message.getStatus();
            map.put(this.STATUS, this.getFontColor(status) + this.getString(status.toString()) + "</font>");
            String first = (String)map.get(firstOrder);
            String second = (String)map.get(secondOrder);
            String third = (String)map.get(thirdOrder);
            builder.append("<strong>");
            if (!first.equals(previousFirst)) {
                if (!previousFirst.equals("")) {
                    builder.append("<br>");
                }
                builder.append(first).append("<br>");
                previousFirst = first;
                previousSecond = "";
            }
            if (!second.equals(previousSecond)) {
                builder.append("&nbsp;&nbsp;").append(second).append("<br>");
                previousSecond = second;
            }
            builder.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(third);
            builder.append("</strong>");
            builder.append(" - ").append(info.message.getMessage());
            builder.append("<br>");
        }
        builder.append("</html>");
        this.textArea.setText(builder.toString());
        this.textArea.setCaretPosition(0);
    }

    private Object getFontColor(TestStatus status) {
        if (status.equals((Object)TestStatus.OK)) {
            return "<font color=\"green\">";
        }
        if (status.equals((Object)TestStatus.WARNING)) {
            return "<font color=\"orange\">";
        }
        if (status.equals((Object)TestStatus.ERROR)) {
            return "<font color=\"red\">";
        }
        return "<font color=\"black\">";
    }

    private String computeThird(String firstOrder, String secondOrder) {
        if (!this.TEST.equals(firstOrder) && !this.TEST.equals(secondOrder)) {
            return this.TEST;
        }
        if (!this.SUBJECT.equals(firstOrder) && !this.SUBJECT.equals(secondOrder)) {
            return this.SUBJECT;
        }
        return this.STATUS;
    }

    private List<ResultInfo<?>> sortData(List<ResultInfo<?>> list, String firstCriteria, String secondCriteria) {
        HashMap compMap = new HashMap();
        compMap.put(this.TEST, new TestComparator());
        compMap.put(this.SUBJECT, new SubjectComparator());
        compMap.put(this.STATUS, new StatusComparator());
        DoubleLevelComparator comparator = new DoubleLevelComparator((Comparator)compMap.get(firstCriteria), (Comparator)compMap.get(secondCriteria));
        Collections.sort(list, comparator);
        return list;
    }

    private List<ResultInfo<?>> filterData(List<ResultInfo<?>> messagesList, boolean okSelected, boolean warningSelected, boolean errorSelected) {
        ArrayList filtered = new ArrayList();
        for (ResultInfo<?> resultInfo : messagesList) {
            if (resultInfo.message.getStatus().equals((Object)TestStatus.OK) && okSelected) {
                filtered.add(resultInfo);
                continue;
            }
            if (resultInfo.message.getStatus().equals((Object)TestStatus.WARNING) && warningSelected) {
                filtered.add(resultInfo);
                continue;
            }
            if (!resultInfo.message.getStatus().equals((Object)TestStatus.ERROR) || !errorSelected) continue;
            filtered.add(resultInfo);
        }
        return filtered;
    }

    private void mountPanel() {
        this.setLayout(new GridBagLayout());
        this.initializeCloseButton();
        this.initializeStatusFilters();
        this.initializeTextStyleButtons();
        this.initializeSortingCombos();
        JComponent[][] filters = new JComponent[][]{{this.okFilter}, {this.warningFilter}, {this.errorFilter}};
        JPanel filtersPanel = GUIUtils.createBasicGridPanel((JComponent[][])filters);
        filtersPanel.setBorder(BorderFactory.createTitledBorder(this.getString("filters.title")));
        JComponent[][] textStyleButtons = new JComponent[][]{{this.colapsedButton}, {this.extendedButton}};
        JPanel textStylePanel = GUIUtils.createBasicGridPanel((JComponent[][])textStyleButtons);
        textStylePanel.setBorder(BorderFactory.createTitledBorder(this.getString("text.style.title")));
        JComponent[][] sortingCombos = new JComponent[][]{{new JLabel(this.getString("first.order.label")), this.firstSorter}, {new JLabel(this.getString("second.order.label")), this.secondSorter}};
        JPanel sortingPanel = GUIUtils.createBasicGridPanel((JComponent[][])sortingCombos);
        sortingPanel.setBorder(BorderFactory.createTitledBorder(this.getString("sorting.title")));
        this.textArea = new JTextPane();
        this.textArea.setFont(new Font("Monospaced", 0, this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        this.textArea.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setMinimumSize(new Dimension(600, 400));
        scrollPane.setPreferredSize(new Dimension(600, 400));
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)filtersPanel, new GBC(0, 0).insets(12, 12, 6, 6).both());
        topPanel.add((Component)textStylePanel, new GBC(1, 0).insets(12, 6, 6, 12).both());
        Container panel = this.getContentPane();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)topPanel, new GBC(0, 0).horizontal());
        panel.add((Component)sortingPanel, new GBC(0, 1).horizontal().insets(6, 12, 6, 12));
        panel.add((Component)scrollPane, new GBC(0, 2).both().insets(6, 12, 6, 12));
        this.add((Component)this.closeButton, new GBC(0, 3).center().none().insets(6, 12, 12, 12));
    }

    private void initializeSortingCombos() {
        if (this.firstSorter != null && this.secondSorter != null) {
            return;
        }
        this.TEST = this.getString("sort.by.test");
        this.STATUS = this.getString("sort.by.status");
        this.SUBJECT = this.getString("sort.by.subject");
        final List<String> allSorters = Arrays.asList(this.SUBJECT, this.STATUS, this.TEST);
        this.firstSorter = new JComboBox<String>(new String[]{this.SUBJECT, this.STATUS, this.TEST});
        this.firstSorter.setSelectedIndex(0);
        this.secondSorter = new JComboBox<String>(new String[]{this.STATUS, this.TEST});
        this.firstSorter.setSelectedIndex(0);
        this.firstSorter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String first = (String)ReportDialog.this.firstSorter.getSelectedItem();
                String second = (String)ReportDialog.this.secondSorter.getSelectedItem();
                ArrayList secondSorters = new ArrayList(allSorters);
                secondSorters.remove(first);
                ReportDialog.this.secondSorter.setModel(new DefaultComboBoxModel<String>(secondSorters.toArray(new String[2])));
                if (second.equals(first)) {
                    ReportDialog.this.secondSorter.setSelectedIndex(0);
                } else {
                    ReportDialog.this.secondSorter.setSelectedItem(second);
                }
                ReportDialog.this.updateTextArea();
            }
        });
        this.secondSorter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.updateTextArea();
            }
        });
    }

    private void initializeTextStyleButtons() {
        if (this.colapsedButton != null && this.extendedButton != null) {
            return;
        }
        this.colapsedButton = new JRadioButton(this.getString("collapsed.button"));
        this.extendedButton = new JRadioButton(this.getString("expanded.button"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.colapsedButton);
        group.add(this.extendedButton);
        this.colapsedButton.setSelected(true);
        this.extendedButton.setSelected(false);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.updateTextArea();
            }
        };
        this.colapsedButton.addActionListener(action);
        this.extendedButton.addActionListener(action);
    }

    private void initializeStatusFilters() {
        if (this.okFilter != null && this.warningFilter != null && this.errorFilter != null) {
            return;
        }
        this.okFilter = new JCheckBox(this.getString("ok.check"));
        this.warningFilter = new JCheckBox(this.getString("warning.check"));
        this.errorFilter = new JCheckBox(this.getString("error.check"));
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.updateTextArea();
            }
        };
        this.okFilter.setSelected(false);
        this.warningFilter.setSelected(true);
        this.errorFilter.setSelected(true);
        this.okFilter.addActionListener(action);
        this.warningFilter.addActionListener(action);
        this.errorFilter.addActionListener(action);
    }

    private void initializeCloseButton() {
        if (this.closeButton != null) {
            return;
        }
        this.closeButton = new JButton(this.getString("close.button"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.closeDialog();
            }
        });
    }

    private List<ResultInfo<?>> convertResult(Map<ITest<?>, ITestResult<?>> testMap) {
        ArrayList messages = new ArrayList();
        for (ITest<?> test : testMap.keySet()) {
            ITestResult<?> result = testMap.get(test);
            for (IResultMessage<?> message : result.getMessages()) {
                ResultInfo info = new ResultInfo();
                info.test = test;
                info.message = message;
                messages.add(info);
            }
        }
        return messages;
    }

    private void closeDialog() {
        this.dispose();
    }

    protected void updateInfoArea(ITestResult<?> result, JTextArea infoArea) {
        infoArea.setText("");
        String text = "";
        for (IResultMessage<?> message : result.getMessages()) {
            text = text + message.getSubject().toString();
            text = text + " - " + message.getStatus().toString();
            text = text + " - " + message.getMessage();
            text = text + "\n\n";
        }
        infoArea.setText(text);
    }

    static class DoubleLevelComparator
    implements Comparator<ResultInfo<?>> {
        private final Comparator<ResultInfo<?>> comp1;
        private final Comparator<ResultInfo<?>> comp2;

        public DoubleLevelComparator(Comparator<ResultInfo<?>> comp1, Comparator<ResultInfo<?>> comp2) {
            this.comp1 = comp1;
            this.comp2 = comp2;
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            int result1 = this.comp1.compare(o1, o2);
            if (result1 == 0) {
                return this.comp2.compare(o1, o2);
            }
            return result1;
        }
    }

    private static class StatusComparator
    implements Comparator<ResultInfo<?>> {
        private StatusComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            TestStatus s2;
            TestStatus s1 = o1.message.getStatus();
            if (s1.equals((Object)(s2 = o2.message.getStatus()))) {
                return 0;
            }
            if (s1 == TestStatus.OK) {
                return -1;
            }
            if (s2 == TestStatus.OK) {
                return 1;
            }
            if (s1 == TestStatus.WARNING) {
                return -1;
            }
            if (s2 == TestStatus.WARNING) {
                return 1;
            }
            if (s1 == TestStatus.ERROR) {
                return -1;
            }
            if (s2 == TestStatus.ERROR) {
                return 1;
            }
            return 0;
        }
    }

    private static class SubjectComparator
    implements Comparator<ResultInfo<?>> {
        private SubjectComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            String s1 = o1.getSubjectName();
            String s2 = o2.getSubjectName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class TestComparator
    implements Comparator<ResultInfo<?>> {
        private TestComparator() {
        }

        @Override
        public int compare(ResultInfo<?> o1, ResultInfo<?> o2) {
            return o1.test.getName().compareToIgnoreCase(o2.test.getName());
        }
    }

    class ResultInfo<T> {
        protected ITest<T> test;
        protected IResultMessage<T> message;

        ResultInfo() {
        }

        String getSubjectName() {
            return this.test.getSubjectName(this.message.getSubject());
        }
    }
}

