/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.NotificationCompositionFrame;
import csbase.client.desktop.NotificationReplyFrame;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.DateTranslator;
import csbase.client.util.NotificationTranslator;
import csbase.exception.ConfigurationException;
import csbase.logic.CommandNotification;
import csbase.logic.Notification;
import csbase.logic.NotificationHandler;
import csbase.logic.User;
import csbase.remote.RemoteEvent;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public abstract class NotificationPanel
implements Observer {
    protected NotificationCompositionFrame composeDialog = null;
    protected JTextArea notificationArea = null;
    protected JPanel mainPanel = null;
    protected Object userId = null;
    protected LinkedList<NotificationHandler> notificationHandlers = null;
    private final Configuration configuration;
    private Map<Class<?>, AtomicLong> finishedCmdsCount = new HashMap();

    private void addNotificationLine(String line) {
        this.notificationArea.append(line);
        this.notificationArea.setCaretPosition(this.notificationArea.getText().length());
    }

    protected final void writeNotificationsLines(List<String> lineList) {
        Iterator<String> lineIterator = lineList.iterator();
        while (lineIterator.hasNext()) {
            this.addNotificationLine(lineIterator.next());
        }
    }

    protected final void openComposeDialog() {
        if (this.composeDialog == null) {
            this.composeDialog = new NotificationCompositionFrame();
        }
        this.composeDialog.start();
    }

    protected final JToolBar createButtonsPanel(ImageIcon composeIcon, ImageIcon clearIcon) {
        JButton notButton = new JButton(composeIcon);
        notButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NotificationPanel.this.openComposeDialog();
            }
        });
        notButton.setToolTipText(LNG.get((String)"notification.send.button.tooltip"));
        JButton clrButton = new JButton(clearIcon);
        clrButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NotificationPanel.this.clearPanel();
            }
        });
        clrButton.setToolTipText(LNG.get((String)"notification.clear.button.tooltip"));
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        toolbar.add(notButton);
        toolbar.add(clrButton);
        return toolbar;
    }

    protected final void clearPanel() {
        this.notificationArea.setText("");
    }

    protected final JPanel createMainPanel(ImageIcon composeIcon, ImageIcon clearIcon) {
        this.notificationArea = new JTextArea();
        this.notificationArea.setEditable(false);
        this.notificationArea.setFont(new Font("Monospaced", 0, 12));
        this.clearPanel();
        JScrollPane scrolledPane = new JScrollPane(this.notificationArea);
        JPanel xPanel = new JPanel();
        xPanel.setLayout(new BorderLayout());
        xPanel.add((Component)scrolledPane, "Center");
        xPanel.add((Component)this.createButtonsPanel(composeIcon, clearIcon), "West");
        return xPanel;
    }

    public final JPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    public final void update(Observable observable, Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Notification) {
            ArrayList<Notification> notifs = new ArrayList<Notification>();
            notifs.add((Notification)obj);
            this.sendMessages(notifs);
        } else if (obj instanceof RemoteEvent[]) {
            RemoteEvent[] events = (RemoteEvent[])obj;
            ArrayList<Notification> notifs = new ArrayList<Notification>();
            for (int i = 0; i < events.length; ++i) {
                if (!(events[i] instanceof Notification)) continue;
                notifs.add((Notification)events[i]);
            }
            if (notifs.size() > 0) {
                this.sendMessages(notifs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationHandler(NotificationHandler handler) {
        LinkedList<NotificationHandler> linkedList = this.notificationHandlers;
        synchronized (linkedList) {
            this.notificationHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callNotificationHandlers(Notification data) {
        LinkedList<NotificationHandler> linkedList = this.notificationHandlers;
        synchronized (linkedList) {
            for (NotificationHandler handler : this.notificationHandlers) {
                handler.gotNotification(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages(ArrayList<Notification> notifications) {
        if (notifications == null || notifications.size() == 0) {
            return;
        }
        boolean msgDisplayed = false;
        NotificationTranslator translator = this.getTranslator();
        if (translator == null) {
            SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Date now = new Date();
                    String msg = LNG.get((String)"notification.translator.null.error");
                    NotificationPanel.this.addNotificationLine(NotificationPanel.this.makeNotificationLine(now, "!!!", msg, false));
                }
            });
            msgDisplayed = true;
        } else {
            for (Notification notification : notifications) {
                String sender;
                Date date;
                if (User.getLoggedUser().isAdmin() && CommandNotification.class.isAssignableFrom(notification.getClass())) {
                    Map<Class<?>, AtomicLong> map = this.finishedCmdsCount;
                    synchronized (map) {
                        AtomicLong count = this.finishedCmdsCount.get(notification.getClass());
                        if (count == null) {
                            count = new AtomicLong(1L);
                            this.finishedCmdsCount.put(notification.getClass(), count);
                        } else {
                            count.incrementAndGet();
                        }
                    }
                    final StringBuilder infoMsg = new StringBuilder("[FIM DE COMANDO] CmdId[").append(((CommandNotification)notification).getCommandId()).append("] Evento[").append(notification.getClass().getSimpleName()).append("]. Total: ");
                    for (Map.Entry<Class<?>, AtomicLong> entry : this.finishedCmdsCount.entrySet()) {
                        infoMsg.append(" [").append(entry.getKey().getSimpleName()).append(":").append(entry.getValue().get()).append("]");
                    }
                    date = new Date(notification.getCreationDate());
                    sender = notification.getSender();
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String line = NotificationPanel.this.makeNotificationLine(date, sender, infoMsg.toString(), true);
                            NotificationPanel.this.addNotificationLine(line);
                        }
                    });
                }
                Object result = null;
                try {
                    Method method = translator.getClass().getMethod("translate", notification.getClass());
                    result = method.invoke((Object)translator, notification);
                }
                catch (Exception e) {
                    result = LNG.get((String)"notification.translation.error") + " - " + notification.toString();
                }
                date = new Date(notification.getCreationDate());
                sender = notification.getSender();
                final String msg = result.toString();
                final boolean mustPopUp = notification.getMustPopUp();
                final boolean vol = notification.isVolatile();
                if (notification.getDisplay()) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String line = NotificationPanel.this.makeNotificationLine(date, sender, msg, vol);
                            NotificationPanel.this.addNotificationLine(line);
                            if (mustPopUp) {
                                NotificationPanel.this.showNotificationPopUp(sender, date, msg);
                            }
                        }
                    });
                    msgDisplayed = true;
                }
                this.callNotificationHandlers(notification);
            }
        }
        if (msgDisplayed) {
            String tag = "notification.beep";
            boolean beepActivated = this.configuration.getOptionalBooleanProperty("notification.beep", true);
            if (beepActivated) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.beep();
            }
        }
    }

    private void showNotificationPopUp(String senderLogin, Date date, String text) {
        NotificationReplyFrame replyFrame = new NotificationReplyFrame(senderLogin, date, text);
        replyFrame.start();
    }

    private String makeNotificationLine(Date date, String senderName, String line, boolean volatileFlag) {
        String prefix = volatileFlag ? "[-] " : "[+] ";
        String formDate = DateTranslator.getInstance().translate(date);
        return prefix + formDate + " - " + "[" + senderName + "]: " + line.replace('\n', ' ') + "\n";
    }

    public final void setUser(User user) {
        Object uid = null;
        if (user != null) {
            uid = user.getId();
        } else if (this.composeDialog != null) {
            this.composeDialog.close();
        }
        if (this.userId != null) {
            NotificationProxy.deleteUserObserver(this, this.userId);
        }
        if (uid != null) {
            NotificationProxy.addUserObserver(this, uid);
        }
        this.userId = uid;
    }

    public abstract NotificationTranslator getTranslator();

    public NotificationPanel(ImageIcon composeIcon, ImageIcon clearIcon) {
        this.notificationHandlers = new LinkedList();
        this.mainPanel = this.createMainPanel(composeIcon, clearIcon);
        try {
            ConfigurationManager manager = ConfigurationManager.getInstance();
            this.configuration = manager.getConfiguration(this.getClass());
        }
        catch (ConfigurationManagerException e) {
            throw new ConfigurationException((Throwable)e);
        }
        MessageProxy.addListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message aMessage : messages) {
                    ArrayList<Notification> notifs = new ArrayList<Notification>();
                    notifs.add((Notification)aMessage.getBody());
                    NotificationPanel.this.sendMessages(notifs);
                }
            }
        }, Notification.class);
    }

    public NotificationPanel() {
        this(ApplicationImages.ICON_COMPOSEMSG_24, ApplicationImages.ICON_CLEARMSG_24);
    }
}

