/*
 * $Id:$
 */
package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.rmi.RemoteException;

import javax.swing.JComponent;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.view.simple.SimpleAlgorithmConfiguratorPanel;
import csbase.client.kernel.ClientException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.validation.ValidationMode;

/**
 * Viso para {@link SimpleAlgorithmConfigurator Configurador de Algoritmos
 * Simples}.
 *
 * @author lmoreira
 */
public class SimpleAlgorithmConfiguratorView extends AlgorithmConfiguratorView {

  /**
   * O componente principal.
   */
  private SimpleAlgorithmConfiguratorPanel mainComponent;

  /**
   * Cria a viso.
   *
   * @param owner A janela que  dona deste dilogo (No aceita {@code null}).
   * @param configurator O configurador (No aceita {@code null}).
   * @param mode Modo de visualizao do configurador. No aceita {@code null},
   *        os possveis valores so: {@link ParameterView.Mode#CONFIGURATION}
   *        ou {@link ParameterView.Mode#REPORT}
   * @param defaultValidationMode O modo de validao padro.
   * @throws ClientException em caso de erro ao criar a viso do configurador.
   */
  public SimpleAlgorithmConfiguratorView(Window owner,
    SimpleAlgorithmConfigurator configurator, ParameterView.Mode mode,
    ValidationMode defaultValidationMode) throws ClientException {
    super(owner, configurator, mode, defaultValidationMode);
    this.mainComponent = createMainComponent(configurator);
    this.mainComponent
    .addParameterGroupViewListener(new ParameterGroupViewListener() {
      @Override
      public void childParameterVisibilityChanged(ParameterGroupView groupView) {
        final AlgorithmConfiguratorView view =
          SimpleAlgorithmConfiguratorView.this;
        view.resizeOnVisibilityChanged();
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean highlightValidationResult(ViewValidationResult result) {
    return mainComponent.highlightValidationResult(result);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ViewValidationResult validate(ValidationMode mode)
    throws RemoteException {
    return mainComponent.validate(mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateView() {
    if(mainComponent != null) {
      mainComponent.updateViews();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public JComponent getMainComponent() {
    return this.mainComponent;
  }

  /**
   * Cria o componente principal.
   *
   * @param configurator O configurador do algoritmo a ser visualizado.
   * @return O painel que  o componente principal dessa viso.
   *
   * @throws ClientException em caso de erro ao criar a viso do configurador.
   */
  private SimpleAlgorithmConfiguratorPanel createMainComponent(
    final SimpleAlgorithmConfigurator configurator) throws ClientException {

    return new SimpleAlgorithmConfiguratorPanel(getOwner(), configurator,
      getMode());
  }
}
