package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;

/**
 * Ao para recarregar os algoritmos instalados no servidor.
 * 
 */
public class ReloadAlgorithmsAction extends AlgorithmsManagerAction {

  /**
   * Constri a ao de recarregar os algoritmos instalados no servidor.
   * 
   * @param application referncia para a aplicao
   */
  public ReloadAlgorithmsAction(AlgorithmsManager application) {
    super(application, ApplicationImages.ICON_REFRESH_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    getApplication().reloadAlgorithmsFromServer();
  }

}
