package csbase.client.applications.algorithmsmanager.dialogs;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;

/**
 * Painel com diviso vertical para organizar as informaes relacionadas ao
 * gerenciamento de categorias e de algoritmos.
 * 
 * Por exemplo, teremos a rvore de categorias no painel  esquerda e os dados
 * do cadastro (edio, incluso e remoo) no painel  direita.
 */
public class AlgorithmsManagerSplitComponent {
  /** Referncia para a aplicao Gerenciador de Algoritmos */
  private AlgorithmsManager application;

  /** Painel com split criado */
  private JSplitPane splitPane;

  /** Painel para seleo dos dados cujas informaes sero manipuladas */
  private JPanel selectionPanel;

  /** Painel com as informaes a serem manipuladas */
  private JPanel infoPanel;

  /** Proporo default do divisor do split */
  // private static final double DEFAULT_DIVIDER_PROPORTION = 0.3d;
  private static final int DEFAULT_DIVIDER_POSITION = 300;

  /** Orientao padro da diviso na janela */
  public static int DEFAULT_SPLIT_ORIENTATION = JSplitPane.HORIZONTAL_SPLIT;

  /**
   * Construtor do painel de split para essa aplicao.
   * 
   * @param application aplicao Gerenciador de Algoritmos
   * @param selectionPanel painel para seleo do dado
   * @param infoPanel painel com as informaes a serem manipuladas
   */
  public AlgorithmsManagerSplitComponent(AlgorithmsManager application,
    JPanel selectionPanel, JPanel infoPanel) {
    this.application = application;
    this.selectionPanel = selectionPanel;
    this.infoPanel = infoPanel;
    buildSplitPane(DEFAULT_SPLIT_ORIENTATION);
  }

  /**
   * Constri o painel com a diviso vertical especificada.
   * 
   * @param orientation orientao inicial do painel, que pode ser vertical ou
   *        horizontal
   * @return o painel com split
   */
  private JSplitPane buildSplitPane(int orientation) {
    splitPane = new JSplitPane(orientation, selectionPanel, infoPanel);
    splitPane.setSize(getApplication().getMainPanelSize());
    splitPane.setDividerLocation(DEFAULT_DIVIDER_POSITION);
    return splitPane;
  }

  /**
   * Obtm o painel com a diviso vertical entre os painis da esquerda (painel
   * de seleo) e da direita (painel de edio).
   * 
   * @return o painel com split
   */
  public JSplitPane getSplitPanel() {
    if (splitPane == null) {
      buildSplitPane(DEFAULT_SPLIT_ORIENTATION);
    }
    return splitPane;
  }

  /**
   * Obtm a referncia para a aplicao Gerenciador de Algoritmos.
   * 
   * @return a aplicao
   */
  public AlgorithmsManager getApplication() {
    return application;
  }

  /**
   * Atualiza o painel com as informaes do dados corrente que sero
   * manipuladas.
   * 
   * @param panel painel com as informaes do dados corrente que sero
   *        manipuladas
   */
  public void updateEditPanel(JPanel panel) {
    getSplitPanel().setRightComponent(panel);
    getSplitPanel().setDividerLocation(DEFAULT_DIVIDER_POSITION);
    getSplitPanel().revalidate();
  }

  /**
   * Atualiza o painel que permite a seleo do dado que ser manipulado. Por
   * exemplo, pode ser um painel com a rvore de categorias ou com a lista de
   * algoritmos, onde o usurio poder selecionar algum item para realizar uma
   * operao de gerenciamento.
   * 
   * @param panel painel que permite a seleo do dao a ser manipulado
   */
  public void updateSelectionPanel(JPanel panel) {
    getSplitPanel().setLeftComponent(panel);
    getSplitPanel().setDividerLocation(DEFAULT_DIVIDER_POSITION);
    getSplitPanel().revalidate();
  }
}
