/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import java.awt.datatransfer.DataFlavor;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.EditDocumentationFileAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportDocumentationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveDocumentationFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.DocumentationPathFactory;
import tecgraf.javautils.core.lng.LNG;

/**
 * @author Tecgraf / PUC-Rio
 *
 *         N que representa arquivos de documentao.
 */
final class DocumentationFileNode extends AbstractFileInfoNode {

  /**
   * Descreve o formato de objeto que pode ser transferido pelas operaces de
   * transferncia (drag&drop ou clipboard) na rvore.
   */
  public static final DataFlavor DATA_FLAVOR = new DataFlavor(
    DocumentationFileNode.class, DocumentationFileNode.class.getSimpleName());

  /**
   * Construtor.
   *
   * @param tree rvore que detm este n.
   * @param version Verso que detm o arquivo representado por este n.
   * @param file Arquivo representado por este n.
   */
  protected DocumentationFileNode(final VersionTree tree,
    final AlgorithmVersionInfo version, final FileInfo file) {
    super(tree, version, file, file1 -> new DocumentationFileNode(tree, version, file1), false);
  }

  /**
   * Cria um menu pop-up para este n.
   *
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(
      getTree(), LNG.get("algomanager.menu.doc.copy")))));
    if (getFile().isDirectory()) {
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new PasteFile(getTree(), LNG.get("algomanager.menu.doc.paste"),
          DocumentationFileNode.DATA_FLAVOR))));
    }
    else {
      if (getTree().getSelectionCount() == 1) {
        popupMenu
          .add(new JMenuItem(
            new VersionWarningActionDecorator(new EditDocumentationFileAction(
              getTree(), getVersion(), getFile()))));
      }
    }
    popupMenu.add(new JMenuItem(
      new VersionWarningActionDecorator(new RemoveDocumentationFiles(getTree(),
        getVersion(), getSelectedFiles()))));
    if (!getFile().isDirectory()) {
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new ExportDocumentationFile(getTree(), getVersion(), getFile()))));
    }

    return popupMenu;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataFlavor getDataFlavor() {
    return DATA_FLAVOR;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createSourcePathFactory(DataTransferObject dto) {
    AlgorithmVersionInfo sourceVersion = dto.getVersion();
    return new DocumentationPathFactory(sourceVersion);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createTargetPathFactory() {
    return new DocumentationPathFactory(getVersion());
  }
}
