/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.rmi.RemoteException;
import java.text.MessageFormat;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao que exporta um arquivo de execuo.
 */
public class ExportExecutableFile extends AbstractExportFileAction {

  /** Verso de origem do arquivo a ser exportado. **/
  private AlgorithmVersionInfo version;
  /** Plataforma de origem do arquivo a ser exportado. **/
  private String platform;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser exportado.
   * @param platform Plataforma de origem do arquivo a ser exportado.
   * @param file Arquivo de execuo a ser exportado.
   */
  public ExportExecutableFile(VersionTree tree, AlgorithmVersionInfo version,
    String platform, FileInfo file) {
    super(tree, LNG.get("algomanager.menu.bin_file.export"), file);

    this.version = version;
    this.platform = platform;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected RemoteFileChannelInfo prepareDownload(FileInfo source)
    throws RemoteException {
    return ClientRemoteLocator.algorithmService.prepareDownloadExecFile(version
      .getInfo().getId(), version.getId(), platform, getSourcePath(source), 
      source.isDirectory());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void appletExport(FileInfo source) {
    String filePath =
      FileUtils.joinPath('/', version.getVersionsDirName(),
        version.getDirectory(), version.getBinDirName(), platform,
        source.getPath());
    String dialogTitle =
      MessageFormat
        .format(LNG.get("algomanager.title.executable"), new Object[] {
            version.getInfo().getName(), version.getId(), platform });
    export(version.getInfo().getId(), filePath, dialogTitle);
  }
}
