/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo a descrio dos ns que executam o comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class NodeColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public NodeColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    if (cmd.getStatus() == CommandStatus.SYSTEM_FAILURE) {
      return getDefaultErrorValue();
    }
    else if (cmd.getExecutionNodeDescription() == null) {
      return getDefaultEmptyValue();
    }
    else {
      return cmd.getExecutionNodeDescription();
    }
  }
}
