/*
 * $Id:$
 */

package csbase.client.applications.filetransferclient.panels.localpanel;

import java.awt.Color;
import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.project.ClientProjectFileProperties;
import csbase.logic.ClientProjectFile;

/**
 * Renderizador da tabela de requisies
 * 
 * @author Tecgraf/PUC-Rio
 */
class LocalTableRenderer implements TableCellRenderer {

  /**
   * Renderer default.
   */
  public static final DefaultTableCellRenderer DEFAULT_RENDERER =
    new DefaultTableCellRenderer();

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    Component renderer =
      DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, column);
    final JLabel label = ((JLabel) renderer);
    label.setOpaque(true);
    label.setIcon(null);
    label.setHorizontalAlignment(SwingConstants.LEFT);
    label.setForeground(Color.black);

    if (column == 0) {
      final ClientProjectFile file = (ClientProjectFile) value;

      label.setHorizontalAlignment(SwingConstants.CENTER);
      final ImageIcon icon = ClientProjectFileProperties.getImageIcon(file);
      label.setIcon(icon);
      label.setText(null);
    }
    else if (column == 1) {
      final String name = (String) value;
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(name);
    }
    else if (column == 2) {
      label.setHorizontalAlignment(SwingConstants.RIGHT);
      long sz = (Long) value;
      if (sz < 0) {
        label.setText(null);
      }
      else {
        final ApplicationManager mgr = ApplicationManager.getInstance();
        label.setText(FormatUtils.formatSize(sz, 2, mgr.getLocale()));
      }
    }

    return label;
  }

  /**
   * Construtor
   */
  public LocalTableRenderer() {
  }

}
