package csbase.client.applications.projectsmanager.models;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;

/**
 * Tipos de operaes que podem ser aplicadas a um projeto e que geram "logs" no
 * histrico do projeto.
 * 
 * @author jnlopes
 * 
 */
public enum ProjectHistoryBlockType {

  /**
   * Projeto se tornou compartilhado (ou houve alterao nos usurios que
   * compartilham o projeto.
   */
  PROJECT_SHARED(),

  /**
   * Projeto se tornou pblico.
   */
  PROJECT_PUBLIC(),

  /**
   * Projeto se tornou privado.
   */
  PROJECT_PRIVATE(),

  /**
   * Usurio se auto-removeu de um projeto que era compartilhado com ele.
   */
  PROJECT_SELF_REMOVAL(),

  /**
   * Reserva de rea do projeto foi alocada.
   */
  AREA_ALLOCATED(),

  /**
   * Texto entrado manualmente pelo dono, ou por um usurio do projeto.
   */
  PERSONAL_TEXT();

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final private String getClassString(final String tag) {
    return ProjectsManagerUI.getClassString(this.getClass(), tag);
  }

  /**
   * Mtodo de teste de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final private boolean hasString(final String tag) {
    return ProjectsManagerUI.hasClassString(this.getClass(), tag);
  }

  /**
   * @return O identificador deste campo da enumerao.
   */
  public String getDescription() {
    final String tag = this.name() + ".description";
    if (hasString(tag))
      return getClassString(tag);
    return null;
  }

}
