/*
 * $Id: ProjectTreeAdapter.java 179359 2017-03-13 19:58:16Z cviana $
 */

package csbase.client.project;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * A classe <code>ProjectTreeAdapter</code> implementa um listener da rvore de
 * projetos que oferece uma implementao vazia para todos os seus mtodos.
 */
public class ProjectTreeAdapter implements ProjectTreeListener {

  /**
   *  chamado sempre as informaes do projeto so modificadas
   */
  @Override
  public void projectInfoModified() {
  }

  /**
   *  chamado sempre que a rvore exibe um novo projeto.
   *
   * @param project projeto
   */
  @Override
  public void projectChanged(final CommonClientProject project) {
  }

  /**
   *  chamado sempre que um projeto  fechado
   */
  @Override
  public void projectClosed(final CommonClientProject project) {
  }

  /**
   *  chamado sempre que um projeto  removido.
   */
  @Override
  public void projectRemoved() {
  }

  /**
   *  chamado sempre que o menu de popup de diretrio for exbido.
   *
   * @param directory diretrio.
   */
  @Override
  public void popupDirTriggered(final ClientProjectFile directory) {
  }

  /**
   *  chamado sempre que o menu de popup de arquivo for exbido.
   *
   * @param directory diretrio.
   */
  @Override
  public void popupFileTriggered(final ClientProjectFile directory) {
  }

  /**
   *  chamado sempre que o menu de popup de seleo mltipla for exbido.
   */
  @Override
  public void popupMultSelectionTriggered() {
  }

  /**
   *  chamado sempre que o menu de popup da raiz for exibido.
   */
  @Override
  public void popupRootTriggered() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void popupDatasetTriggered(ClientProjectFile dataset) {
  }
}
