package csbase.client.rest.resources.v1;

import javax.swing.SwingUtilities;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

import csbase.client.desktop.DesktopFrame;
import io.swagger.annotations.*;

/**
 * Classe que implementa o endpoint Rest para aes do Desktop. Mtodos nesse
 * servio so exportados a partir da URL base desktop;
 */
@Path("v1/desktop")
@Api(value = "Desktop", authorizations = {@Authorization(value="Bearer", scopes = {})})
public class DesktopRestService {

  /**
   * Endpoint do mtodo POST para shutdown.
   * 
   * @return A resposta Rest relativa  requisio.
   */
  @POST
  @Path("/shutdown")
  @ApiOperation(
          value = "Shutdown the client Desktop",
          notes = "This can only be done by the logged in user.")
  @ApiImplicitParams({ @ApiImplicitParam(
          name = "Authorization",
          value = "Token (Bearer $TOKEN)",
          dataType = "string",
          required = true,
          paramType = "header") })
  @ApiResponses(value = {
          @ApiResponse(code = 200, message = "Successful operation"),
  })
  public Response shutdownDesktop() {

    Runnable runnable = new Runnable() {
      @Override
      public void run() {
        try {
          Thread.sleep(5000);
          DesktopFrame.getInstance().shutdownDesktop();
        }
        catch (InterruptedException e) {

        }
      }
    };

    SwingUtilities.invokeLater(runnable);

    return Response.ok().entity("").build();
  }

  /**
   * Endpoint do mtodo POST para tornar o cliente visvel.
   * 
   * @return A resposta Rest relativa  requisio.
   */
  @POST
  @Path("/visible")
  @ApiOperation(
          value = "Makes the client Desktop visible",
          notes = "This can only be done by the logged in user.")
  @ApiImplicitParams({ @ApiImplicitParam(
          name = "Authorization",
          value = "Token (Bearer $TOKEN)",
          dataType = "string",
          required = true,
          paramType = "header") })
  @ApiResponses(value = {
          @ApiResponse(code = 200, message = "Successful operation"),
  })
  public Response setDesktopVisible() {

    try {
      DesktopFrame.getInstance().setDesktopVisible(true);
    }
    catch (Exception e) {
      return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e
        .getLocalizedMessage()).build();
    }
    return Response.ok().entity("").build();
  }

  /**
   * Endpoint do mtodo POST para tornar o cliente invisvel.
   * 
   * @return A resposta Rest relativa  requisio.
   */
  @POST
  @Path("/invisible")
  @ApiOperation(
          value = "Makes the client Desktop invisible",
          notes = "This can only be done by the logged in user.")
  @ApiImplicitParams({ @ApiImplicitParam(
          name = "Authorization",
          value = "Token (Bearer $TOKEN)",
          dataType = "string",
          required = true,
          paramType = "header") })
  @ApiResponses(value = {
          @ApiResponse(code = 200, message = "Successful operation"),
  })
  public Response setDesktopInvisible() {

    try {
      DesktopFrame.getInstance().setDesktopVisible(false);
    }
    catch (Exception e) {
      return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity(e
        .getLocalizedMessage()).build();
    }
    return Response.ok().entity("").build();
  }

}