/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.AlgorithmConfiguratorViewListener;
import csbase.client.algorithms.tasks.ViewValidationTask;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.applications.flowapplication.CompassDirection;
import csbase.client.applications.flowapplication.SVGVO;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphElementListener;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphImages;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNodeDecoration;
import csbase.client.applications.flowapplication.graph.GraphNodeImageDecoration;
import csbase.client.applications.flowapplication.graph.GraphNodeTextDecoration;
import csbase.client.applications.flowapplication.graph.GraphPoint;
import csbase.client.applications.flowapplication.graph.GraphString;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.client.applications.flowapplication.graph.HideableGraphString;
import csbase.client.applications.flowapplication.graph.NodeParameterViewer;
import csbase.client.applications.flowapplication.graph.ParametersTransferable;
import csbase.client.applications.flowapplication.graph.utils.CopyAndPasteOperation;
import csbase.client.applications.flowapplication.graph.utils.GraphNodeUpdateOperation;
import csbase.client.applications.flowapplication.graph.utils.OperationStatus;
import csbase.client.applications.flowapplication.messages.ErrorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import csbase.client.applications.flowapplication.messages.ShowParameterValuesMessage;
import csbase.client.applications.flowapplication.util.FlowApplicationRemoteTask;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmConfiguratorListener;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;

public final class GraphNode
extends GraphElement
implements ViewValidator {
    private static final Color SHADOW_COLOR = new Color(100, 100, 100, 100);
    private static final double SHADOW_FACTOR = 1.075;
    private static final double BORDER_MARGIN = 5.0;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Font ALGORITHM_NAME_FONT = new Font("SansSerif", 1, 12);
    private static final Font ALGORITHM_VERSION_FONT = new Font("SansSerif", 0, 10);
    private static final Stroke BYPASSED_STROKE = new BasicStroke(0.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
    private static final Color DEFAULT_FOREGROUNG_COLOR = Color.BLACK;
    private static final Color ERROR_COLOR = new Color(255, 182, 182);
    private static final Color BYPASSED_TEXT_COLOR = new Color(150, 150, 150);
    private static final double MAX_IMAGE_DIMENSION = 25.0;
    private static final double MIN_HEIGHT = 36.0;
    private static final double MIN_WIDTH = 72.0;
    private static final int NORTH_EAST_INDEX = 1;
    private static final int NORTH_WEST_INDEX = 0;
    private static final Color NOT_READY_BACKGROUND_COLOR = new Color(255, 255, 210);
    private static final Color READY_BACKGROUND_COLOR = new Color(210, 255, 210);
    private static final int SOUTH_EAST_INDEX = 2;
    private static final int SOUTH_WEST_INDEX = 3;
    private AlgorithmInfo algorithm;
    private final GraphString algorithmNameView;
    private final HideableGraphString algorithmVersionIdView;
    private final AlgorithmVersionId algorithmVersionId;
    private Color borderColor;
    private Color backgroundColor;
    private AlgorithmConfiguratorView configuratorView;
    private GraphPoint[] cornerViews;
    private Dimension dimension;
    private SVGVO icon;
    private List<GraphFileDescriptor> inputFileTypeViews;
    private List<GraphFileDescriptor> outputFileTypeViews;
    private FileURLValue standardOutputFile;
    private boolean hasExitCode;
    private FileURLValue exitCodeLogFile;
    private FileURLValue warningsFile;
    private final Map<String, String> parameterLabelsByName;
    private final Set<String> parameterNames;
    private final Map<String, String> parameterTypesByName;
    private final Map<String, String> parameterValuesByName;
    private Point northWestPoint;
    private Shape shape;
    private Shape shadowShape;
    private boolean bypassed;
    private boolean canBypass;
    private GraphNodeDecoration<?> decoration;
    private boolean layoutChanged;

    GraphNode(Graph graph, int id, AlgorithmConfiguratorView configuratorView, Point2D point, boolean bypassed, boolean versionInfoVisible) {
        this(graph, id, configuratorView, point, null, bypassed, versionInfoVisible);
    }

    public boolean hasExitCode() {
        return this.hasExitCode;
    }

    public void setHasExitCode(boolean hasExitCode) {
        this.hasExitCode = hasExitCode;
    }

    GraphNode(Graph graph, int id, AlgorithmConfiguratorView configuratorView, Point2D point, Dimension2D size, boolean bypassed, boolean versionInfoVisible) {
        super(graph, id);
        this.bypassed = bypassed;
        this.canBypass = true;
        this.borderColor = DEFAULT_FOREGROUNG_COLOR;
        this.backgroundColor = NOT_READY_BACKGROUND_COLOR;
        this.configuratorView = configuratorView;
        AlgorithmConfigurator configurator = this.configuratorView.getConfigurator();
        AlgorithmVersionInfo algorithmVersion = configurator.getAlgorithmVersion();
        this.algorithm = algorithmVersion.getInfo();
        this.algorithmNameView = new GraphString((TypeVS)this, this.algorithm.toString(), ALGORITHM_NAME_FONT);
        this.algorithmVersionId = algorithmVersion.getId();
        this.algorithmVersionIdView = new HideableGraphString((TypeVS)this, this.algorithmVersionId.toString(), ALGORITHM_VERSION_FONT, versionInfoVisible);
        this.parameterLabelsByName = new HashMap<String, String>();
        this.parameterValuesByName = new HashMap<String, String>();
        this.parameterTypesByName = new HashMap<String, String>();
        this.parameterNames = new HashSet<String>();
        this.hasExitCode = configurator.hasExitCode();
        this.layoutChanged = false;
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String parameterName : configurator.getParameterNames()) {
            try {
                String parameterLabel = configurator.getParameterLabel(parameterName);
                String parameterType = configurator.getParameterType(parameterName);
                this.addParameter(parameterName, parameterLabel, parameterType);
                String parameterValue = configurator.getParameterValue(parameterName);
                parameterValues.put(parameterName, parameterValue);
            }
            catch (ParameterNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            this.setParameterValuesByName(parameterValues);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        catch (ParameterNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (GraphNodeUpdateOperation.hasNewerVersion(this)) {
            this.icon = new SVGVO(GraphImages.ICON_OUTDATED);
            this.icon.setVerticalAlignment(SVGVO.VerticalAlignment.CENTER);
            this.icon.setHorizontalAlignment(SVGVO.HorizontalAlignment.LEFT);
        }
        this.adjustTextPadding();
        this.decoration = null;
        if (size != null) {
            this.setBounds2D(point.getX(), point.getY(), size.getWidth(), size.getHeight());
        } else {
            this.computeMeasures(point);
        }
        this.setUpVix();
        this.adjustGrid();
        this.setListeners();
        this.fullValidation();
    }

    private void adjustTextPadding() {
        int normalPadding = 3;
        int imagePadding = 0;
        int rightPadding = normalPadding;
        int leftPadding = normalPadding;
        if (this.decoration != null) {
            rightPadding = imagePadding;
        }
        if (this.icon != null) {
            leftPadding = imagePadding;
        }
        this.algorithmNameView.setRightPadding(rightPadding);
        this.algorithmVersionIdView.setRightPadding(rightPadding);
        this.algorithmNameView.setLeftPadding(leftPadding);
        this.algorithmVersionIdView.setLeftPadding(leftPadding);
        this.algorithmNameView.setTopPadding(0.0);
        this.algorithmVersionIdView.setTopPadding(0.0);
        this.algorithmVersionIdView.setBottomPadding(0.0);
    }

    private void fullValidation() {
        this.validateBypass();
        ViewValidationResult result = this.validate(ValidationMode.FULL);
        this.highlightValidationResult(result);
    }

    GraphNode(Graph graph, int id, AlgorithmInfo algorithmInfo, AlgorithmVersionId versionId, Point2D point, Dimension2D size, boolean bypassed, boolean versionInfoVisible) {
        this(graph, id, algorithmInfo.getName(), versionId, point, size, bypassed, versionInfoVisible);
        this.algorithm = algorithmInfo;
    }

    GraphNode(Graph graph, int id, String algorithmName, AlgorithmVersionId versionId, Point2D point, Dimension2D size, boolean bypassed, boolean versionInfoVisible) {
        super(graph, id);
        this.bypassed = bypassed;
        this.canBypass = true;
        this.inputFileTypeViews = new LinkedList<GraphFileDescriptor>();
        this.outputFileTypeViews = new LinkedList<GraphFileDescriptor>();
        this.borderColor = DEFAULT_FOREGROUNG_COLOR;
        this.backgroundColor = ERROR_COLOR;
        this.algorithmNameView = new GraphString((TypeVS)this, algorithmName, ALGORITHM_NAME_FONT);
        this.algorithmVersionId = versionId;
        this.algorithmVersionIdView = new HideableGraphString((TypeVS)this, versionId.toString(), ALGORITHM_VERSION_FONT, versionInfoVisible);
        this.parameterNames = new HashSet<String>();
        this.parameterLabelsByName = new HashMap<String, String>();
        this.parameterValuesByName = new HashMap<String, String>();
        this.parameterTypesByName = new HashMap<String, String>();
        this.decoration = null;
        this.hasExitCode = false;
        this.layoutChanged = false;
        this.setUpVix();
        this.adjustTextPadding();
        this.setBounds2D(point.getX(), point.getY(), size.getWidth(), size.getHeight());
    }

    public void setStandardOutputFile(FileURLValue standardOutputFile) {
        this.standardOutputFile = standardOutputFile;
        if (null != this.configuratorView && null != this.configuratorView.getConfigurator()) {
            this.configuratorView.getConfigurator().setStandardOutputFile(standardOutputFile);
        }
    }

    public void setWarningsFile(FileURLValue warningsFile) {
        this.warningsFile = warningsFile;
        if (null != this.configuratorView && null != this.configuratorView.getConfigurator()) {
            this.configuratorView.getConfigurator().setWarningsFile(warningsFile);
        }
    }

    public void setExitCodeLogFile(FileURLValue exitCodeLogFile) {
        this.exitCodeLogFile = exitCodeLogFile;
        if (null != this.configuratorView && null != this.configuratorView.getConfigurator()) {
            this.configuratorView.getConfigurator().setExitCodeLogFile(exitCodeLogFile);
        }
    }

    public FileURLValue getStandardOutputFile() {
        return this.standardOutputFile;
    }

    public FileURLValue getExitCodeLogFile() {
        return this.exitCodeLogFile;
    }

    public FileURLValue getWarningsFile() {
        return this.warningsFile;
    }

    public boolean addInputFileDescriptor(GraphFileDescriptor graphFileDescriptor) {
        if (graphFileDescriptor == null) {
            throw new IllegalArgumentException("O par\u00e2metro graphFileDescriptor est\u00e1 nulo.");
        }
        if (this.inputFileTypeViews.contains((Object)graphFileDescriptor)) {
            return false;
        }
        this.inputFileTypeViews.add(graphFileDescriptor);
        this.changeVO(null, (TypeVO)graphFileDescriptor);
        graphFileDescriptor.changeVS(null, (TypeVS)this);
        this.updateInputFileTypes();
        return true;
    }

    public boolean addOutputFileDescriptor(GraphFileDescriptor graphFileDescriptor) {
        if (graphFileDescriptor == null) {
            throw new IllegalArgumentException("O par\u00e2metro graphFileDescriptor est\u00e1 nulo.");
        }
        if (this.outputFileTypeViews.contains((Object)graphFileDescriptor)) {
            return false;
        }
        this.outputFileTypeViews.add(graphFileDescriptor);
        this.changeVO(null, (TypeVO)graphFileDescriptor);
        graphFileDescriptor.changeVS(null, (TypeVS)this);
        this.updateOutputFileTypes();
        return true;
    }

    public boolean addParameter(String parameterName, String parameterLabel, String parameterType) {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        if (parameterLabel == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterLabel est\u00e1 nulo.");
        }
        if (parameterType == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterType est\u00e1 nulo.");
        }
        if (this.parameterNames.contains(parameterName)) {
            return false;
        }
        this.parameterNames.add(parameterName);
        this.parameterLabelsByName.put(parameterName, parameterLabel);
        this.parameterTypesByName.put(parameterName, parameterType);
        return true;
    }

    public void askForParameterValues() {
        if (this.isWellFormed()) {
            this.configuratorView.setEnabled(true);
            this.configuratorView.launch();
        } else {
            this.showError();
        }
    }

    @Override
    public void callbackRepaint(Graphics2D g) {
        Stroke stroke;
        if (this.layoutChanged) {
            if (this.computeMeasures(this.getCenterPoint())) {
                this.layoutChanged = false;
            } else {
                return;
            }
        }
        if (this.isBypassed() && this.canBeBypassed()) {
            stroke = BYPASSED_STROKE;
        } else {
            g.setPaint(SHADOW_COLOR);
            g.fill(this.shadowShape);
            g.setPaint(this.backgroundColor);
            g.fill(this.shape);
            stroke = DEFAULT_STROKE;
        }
        g.setPaint(this.borderColor);
        g.setStroke(stroke);
        g.draw(this.shape);
        if (this.isSelected()) {
            for (GraphPoint cornerView : this.cornerViews) {
                cornerView.paint(g);
            }
        }
        super.callbackRepaint(g);
    }

    public GraphLink createLink(Point2D pt) {
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            if (!outputFileType.isWellFormed()) {
                return null;
            }
            if (!outputFileType.contains(pt)) continue;
            GraphLink link = this.getGraph().createLink(outputFileType);
            return link;
        }
        return null;
    }

    @Override
    public void deattach() {
        for (GraphLink link : this.getLinkCollection()) {
            link.deattach();
        }
        super.deattach();
    }

    public boolean finishLink(GraphLink link, Point2D pt) {
        GraphFileDescriptor inputFileType = this.getInputFileDescriptor(pt);
        if (inputFileType == null) {
            return false;
        }
        return link.finish(inputFileType);
    }

    public AlgorithmInfo getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmConfiguratorView getAlgorithmConfiguratorView() {
        return this.configuratorView;
    }

    public String getAlgorithmName() {
        return this.algorithmNameView.getText();
    }

    public AlgorithmVersionId getAlgorithmVersionId() {
        return this.algorithmVersionId;
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D inputFileBounds = this.getBoundsFileTypes(this.inputFileTypeViews);
        Rectangle2D outputFileBounds = this.getBoundsFileTypes(this.outputFileTypeViews);
        Rectangle2D bounds = this.shape.getBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double y = bounds.getMinY();
        double x = bounds.getMinX();
        bounds.setFrame(x, y, w, h);
        bounds = bounds.createUnion(inputFileBounds);
        bounds = bounds.createUnion(outputFileBounds);
        return bounds;
    }

    public CompassDirection getCompassDirection(Point2D pt) {
        double westX = this.cornerViews[0].getLocation().getX();
        double eastX = this.cornerViews[1].getLocation().getX();
        double northY = this.cornerViews[0].getLocation().getY();
        double southY = this.cornerViews[3].getLocation().getY();
        if (this.isContainedInRectangle(westX, northY, westX + 5.0, northY + 5.0, pt)) {
            return CompassDirection.NORTH_WEST;
        }
        if (this.isContainedInRectangle(eastX - 5.0, northY, eastX, northY + 5.0, pt)) {
            return CompassDirection.NORTH_EAST;
        }
        if (this.isContainedInRectangle(westX, southY - 5.0, westX + 5.0, southY, pt)) {
            return CompassDirection.SOUTH_WEST;
        }
        if (this.isContainedInRectangle(eastX - 5.0, southY - 5.0, eastX, southY, pt)) {
            return CompassDirection.SOUTH_EAST;
        }
        if (this.cornerViews[2].getBounds().contains(pt)) {
            return CompassDirection.SOUTH_EAST;
        }
        if (this.isContainedInRectangle(westX, northY, eastX, northY + 5.0, pt)) {
            return CompassDirection.NORTH;
        }
        if (this.isContainedInRectangle(westX, southY - 5.0, eastX, southY, pt)) {
            return CompassDirection.SOUTH;
        }
        if (this.isContainedInRectangle(eastX - 5.0, northY, eastX, southY, pt)) {
            return CompassDirection.EAST;
        }
        if (this.isContainedInRectangle(westX, northY, westX + 5.0, southY, pt)) {
            return CompassDirection.WEST;
        }
        return null;
    }

    public double getHeight() {
        return this.shape.getBounds().getHeight();
    }

    @Override
    public String getHint(Point2D pt) {
        GraphFileDescriptor fileType = this.pickFileType(pt);
        if (fileType != null) {
            return fileType.getHint();
        }
        if (this.contains(pt)) {
            Object image;
            if (this.icon != null && this.icon.getBounds2D().contains(pt)) {
                return LNG.get((String)"algorithms.warning.new_version");
            }
            if (this.decoration != null && (image = this.decoration.getVO()) != null && image.getBounds2D().contains(pt)) {
                return this.decoration.getDescription();
            }
            return (Object)((Object)this.algorithmNameView) + " " + (Object)((Object)this.algorithmVersionIdView) + " (" + this.getId() + ")";
        }
        return null;
    }

    public GraphFileDescriptor getInputFileDescriptor(Point2D pt) {
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            if (!inputFileType.contains(pt)) continue;
            return inputFileType;
        }
        return null;
    }

    public GraphFileDescriptor getInputFileDescriptor(String parameterName) {
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            if (!inputFileType.getParameterName().equals(parameterName)) continue;
            return inputFileType;
        }
        return null;
    }

    public Collection<GraphFileDescriptor> getInputFileDescriptorCollection() {
        return Collections.unmodifiableCollection(this.inputFileTypeViews);
    }

    public boolean canCreateLogFile() {
        if (this.configuratorView == null) {
            return false;
        }
        AlgorithmConfigurator configurator = this.configuratorView.getConfigurator();
        FileURLValue logFile = configurator.getLogFile();
        return logFile != null;
    }

    public ClientProjectFile getStandardOutputClientProjectFile() {
        if (this.configuratorView == null) {
            return null;
        }
        AlgorithmConfigurator configurator = this.configuratorView.getConfigurator();
        FileURLValue stdout = configurator.getStandardOutputFile();
        if (stdout == null) {
            return null;
        }
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        ClientProjectFile projectDirectory = project.getRoot();
        String[] path = stdout.getPathAsArray();
        ClientProjectFile previousFile = projectDirectory;
        ClientProjectFile currentFile = null;
        for (String fileName : path) {
            currentFile = GetChildFromNameTask.runTask(previousFile, fileName);
            if (currentFile == null) {
                if (this.refreshProjectTree()) {
                    return null;
                }
                currentFile = GetChildFromNameTask.runTask(previousFile, fileName);
                if (currentFile == null) {
                    return null;
                }
                return null;
            }
            previousFile = currentFile;
        }
        return currentFile;
    }

    private boolean refreshProjectTree() {
        FlowApplicationRemoteTask<Void> task = new FlowApplicationRemoteTask<Void>(){

            protected void performTask() throws Exception {
                CommonClientProject project = DesktopFrame.getInstance().getProject();
                project.refreshTree();
            }
        };
        Graph graph = this.getGraph();
        Window window = graph.getParentWindow();
        String title = LNG.get((String)(GraphNode.class.getSimpleName() + ".refresh_tree.title"));
        String message = LNG.get((String)(GraphNode.class.getSimpleName() + ".refresh_tree.msg"));
        return task.execute(window, title, message);
    }

    public GraphFileDescriptor getOutputFileDescriptor(Point2D pt) {
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            if (!outputFileType.contains(pt)) continue;
            return outputFileType;
        }
        return null;
    }

    public GraphFileDescriptor getOutputFileDescriptor(String parameterName) {
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            if (!outputFileType.getParameterName().equals(parameterName)) continue;
            return outputFileType;
        }
        return null;
    }

    public Collection<GraphFileDescriptor> getOutputFileDescriptorCollection() {
        return Collections.unmodifiableCollection(this.outputFileTypeViews);
    }

    public String getParameterLabel(String parameterName) throws ParameterNotFoundException {
        String label = this.parameterLabelsByName.get(parameterName);
        if (label == null) {
            throw new ParameterNotFoundException(parameterName);
        }
        return label;
    }

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameterNames);
    }

    public String getParameterType(String parameterName) throws ParameterNotFoundException {
        String type = this.parameterTypesByName.get(parameterName);
        if (type == null) {
            throw new ParameterNotFoundException(parameterName);
        }
        return type;
    }

    public String getParameterValue(String parameterName) throws ParameterNotFoundException {
        if (this.isWellFormed()) {
            return this.configuratorView.getConfigurator().getParameterValue(parameterName);
        }
        if (!this.parameterNames.contains(parameterName)) {
            throw new ParameterNotFoundException(parameterName);
        }
        return this.parameterValuesByName.get(parameterName);
    }

    public double getWidth() {
        return this.shape.getBounds().getWidth();
    }

    public double getX() {
        return this.shape.getBounds().getX();
    }

    public double getY() {
        return this.shape.getBounds().getY();
    }

    public boolean hasLinksFrom() {
        return !this.getLinkFromCollection().isEmpty();
    }

    public boolean hasLinksTo() {
        return !this.getLinkToCollection().isEmpty();
    }

    public boolean isWellFormed() {
        return this.getAlgorithmConfiguratorView() != null;
    }

    @Override
    public boolean msgHandlerVO(TypeMessage message) {
        if (message instanceof PickNodeMessage) {
            return this.handlePickNodeMessage((PickNodeMessage)message);
        }
        if (message instanceof ShowParameterValuesMessage) {
            return this.handleShowParameterValuesMessage();
        }
        if (message instanceof PasteMessage) {
            return this.handlePasteMessage((PasteMessage)message);
        }
        return super.msgHandlerVO(message);
    }

    public void resize(Point2D pt, CompassDirection compassDirection) {
        if (CompassDirection.NORTH.equals(compassDirection)) {
            this.resizeNorth(pt);
        } else if (CompassDirection.SOUTH.equals(compassDirection)) {
            this.resizeSouth(pt);
        } else if (CompassDirection.EAST.equals(compassDirection)) {
            this.resizeEast(pt);
        } else if (CompassDirection.WEST.equals(compassDirection)) {
            this.resizeWest(pt);
        } else if (CompassDirection.NORTH_EAST.equals(compassDirection)) {
            this.resizeNorthEast(pt);
        } else if (CompassDirection.NORTH_WEST.equals(compassDirection)) {
            this.resizeNorthWest(pt);
        } else if (CompassDirection.SOUTH_EAST.equals(compassDirection)) {
            this.resizeSouthEast(pt);
        } else if (CompassDirection.SOUTH_WEST.equals(compassDirection)) {
            this.resizeSouthWest(pt);
        }
        for (GraphElementListener listener : this.getListenerList()) {
            listener.wasResized(this);
        }
    }

    public void setParameterValue(String parameterName, String parameterValue) throws ParseException, ParameterNotFoundException {
        if (this.isWellFormed()) {
            AlgorithmConfigurator configurator = this.configuratorView.getConfigurator();
            configurator.setParameterValue(parameterName, parameterValue);
        } else if (this.parameterNames.contains(parameterName)) {
            this.parameterValuesByName.put(parameterName, parameterValue);
        }
    }

    public void setParameterValuesByName(Map<String, String> parameterValuesByName) throws ParseException, ParameterNotFoundException {
        if (this.isWellFormed()) {
            AlgorithmConfigurator configurator = this.configuratorView.getConfigurator();
            configurator.setParameterValuesByName(parameterValuesByName);
        } else {
            for (String parameterName : parameterValuesByName.keySet()) {
                String parameterValue = parameterValuesByName.get(parameterName);
                if (!this.parameterNames.contains(parameterName)) continue;
                this.parameterValuesByName.put(parameterName, parameterValue);
            }
        }
    }

    protected LocalizedMessage getErrorMessage() {
        LocalizedMessage errorMessage = this.algorithm == null ? new LocalizedMessage(GraphNode.class, "error_algorithm_not_exists", new Object[]{this.algorithmNameView.getText()}) : new LocalizedMessage(GraphNode.class, "error_version_not_exists", new Object[]{this.algorithmNameView.getText(), this.algorithmVersionIdView});
        return errorMessage;
    }

    public void showError() {
        LocalizedMessage errorMessage = this.getErrorMessage();
        new ErrorMessage(errorMessage.getKey(), errorMessage.getArgs()).sendVS((TypeVS)this);
    }

    public void showParameterValues() {
        if (this.configuratorView != null) {
            this.configuratorView.setEnabled(false);
            this.configuratorView.launch();
        } else {
            new NodeParameterViewer(this).execute();
        }
    }

    public boolean startLink(GraphLink link, Point2D pt) {
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            if (!outputFileType.contains(pt)) continue;
            return link.start(outputFileType);
        }
        return false;
    }

    public String toString() {
        return this.algorithmNameView.getText();
    }

    @Override
    public void turnOffHighlight() {
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            inputFileType.turnOffHightLight();
        }
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            outputFileType.turnOffHightLight();
        }
        this.borderColor = DEFAULT_FOREGROUNG_COLOR;
        Color textColor = this.isBypassed() && this.canBeBypassed() ? BYPASSED_TEXT_COLOR : DEFAULT_FOREGROUNG_COLOR;
        this.algorithmNameView.setColor(textColor);
        this.algorithmVersionIdView.setColor(textColor);
    }

    public void turnOnHighlight() {
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            inputFileType.turnOnHightLight();
        }
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            outputFileType.turnOnHightLight();
        }
        this.borderColor = HIGHT_LIGHT_COLOR;
        this.algorithmNameView.setColor(HIGHT_LIGHT_COLOR);
        this.algorithmVersionIdView.setColor(HIGHT_LIGHT_COLOR);
    }

    @Override
    public boolean turnOnHighlight(Point2D pt) {
        if (!this.contains(pt)) {
            return false;
        }
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            if (!inputFileType.contains(pt)) continue;
            inputFileType.turnOnHightLight();
            return true;
        }
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            if (!outputFileType.contains(pt)) continue;
            outputFileType.turnOnHightLight();
            return true;
        }
        this.borderColor = HIGHT_LIGHT_COLOR;
        this.algorithmNameView.setColor(HIGHT_LIGHT_COLOR);
        this.algorithmVersionIdView.setColor(HIGHT_LIGHT_COLOR);
        return true;
    }

    @Override
    public ViewValidationResult validate(ValidationMode mode) {
        if (!this.isBypassed()) {
            if (!this.isWellFormed()) {
                LocalizedMessage errorMessage = this.getErrorMessage();
                return new ViewValidationResult(errorMessage, (ViewValidator)this);
            }
            ViewValidationResult validation = this.validateInputFiles();
            if (!validation.isWellSucceded()) {
                return validation;
            }
            validation = this.validateOutputFiles();
            if (!validation.isWellSucceded()) {
                return validation;
            }
            validation = this.validateAlgorithmConfigurator(mode);
            if (!validation.isWellSucceded()) {
                return validation;
            }
        }
        return new ViewValidationResult(this);
    }

    @Override
    protected boolean contains(Point2D pt) {
        return this.getBounds2D().contains(pt);
    }

    @Override
    protected void doDrag(double tx, double ty) {
        double x = this.northWestPoint.getX() + tx;
        double y = this.northWestPoint.getY() + ty;
        this.northWestPoint.setLocation(x, y);
        if (this.icon != null || this.decoration != null) {
            this.updateImages();
        }
        this.createShape();
        this.updateFileTypes();
        this.updateTextLocation();
        this.adjustGrid();
    }

    @Override
    protected boolean doDrag(Point2D startPoint, Point2D endPoint) {
        double tx = endPoint.getX() - startPoint.getX();
        double ty = endPoint.getY() - startPoint.getY();
        Point2D.Double newPoint = new Point2D.Double(this.northWestPoint.getX() + tx, this.northWestPoint.getY() + ty);
        this.northWestPoint.setLocation(newPoint);
        if (this.icon != null || this.decoration != null) {
            this.updateImages();
        }
        this.createShape();
        this.updateFileTypes();
        this.updateTextLocation();
        this.adjustGrid();
        return true;
    }

    @Override
    protected void doDrop(Point2D pt) {
        this.doDrag(this.getFirstPoint(), Grid.adjustPoint(this.getFirstPoint()));
        this.adjustFileTypes();
    }

    private void adjustFileTypes() {
        for (GraphFileDescriptor descriptor : this.inputFileTypeViews) {
            descriptor.adjustGrid();
        }
        for (GraphFileDescriptor descriptor : this.outputFileTypeViews) {
            descriptor.adjustGrid();
        }
    }

    boolean canReach(GraphNode node) {
        if (this.equals(node)) {
            return true;
        }
        for (GraphLink link : this.getLinkFromCollection()) {
            GraphNode endNode = link.getEndNode();
            if (endNode == null || !endNode.canReach(node)) continue;
            return true;
        }
        return false;
    }

    public Collection<GraphLink> getLinkCollection() {
        HashSet<GraphLink> linkSet = new HashSet<GraphLink>();
        linkSet.addAll(this.getLinkFromCollection());
        linkSet.addAll(this.getLinkToCollection());
        return linkSet;
    }

    public Collection<GraphLink> getLinkFromCollection() {
        LinkedList<GraphLink> linkFromCollection = new LinkedList<GraphLink>();
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            linkFromCollection.addAll(outputFileType.getLinkFromCollection());
        }
        return linkFromCollection;
    }

    public Collection<GraphLink> getLinkToCollection() {
        LinkedList<GraphLink> linkToCollection = new LinkedList<GraphLink>();
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            GraphLink link = inputFileType.getLinkTo();
            if (link == null) continue;
            linkToCollection.add(link);
        }
        return linkToCollection;
    }

    boolean isReadyToExecute() {
        return this.backgroundColor.equals(READY_BACKGROUND_COLOR);
    }

    private void adjustGrid() {
        Double tX = null;
        Double tY = null;
        if (this.getBounds2D().getMinX() < 0.0) {
            tX = -1.0 * this.getBounds2D().getMinX();
        }
        if (this.getBounds2D().getMinY() < 0.0) {
            tY = -1.0 * this.getBounds2D().getMinY();
        }
        if (tX == null && tY == null) {
            return;
        }
        if (tX == null) {
            tX = 0.0;
        }
        if (tY == null) {
            tY = 0.0;
        }
        this.doDrag(tX, tY);
    }

    public Dimension getMinimumSize() {
        if (!this.canComputeSize()) {
            return null;
        }
        double width = this.getMinimumWidth() + this.getImagesWidth();
        double height = this.getMinimumHeight();
        Dimension size = new Dimension();
        size.setSize(width, height);
        return size;
    }

    private boolean computeMeasures(Point2D centerPoint) {
        if (!this.canComputeSize()) {
            return false;
        }
        Dimension size = this.getMinimumSize();
        if (this.shape != null) {
            Rectangle previousSize = this.shape.getBounds();
            double width = Math.max(size.getWidth(), previousSize.getWidth());
            double height = Math.max(size.getHeight(), previousSize.getHeight());
            size.setSize(width, height);
        }
        Point2D origin = this.getOriginFromCenter(centerPoint, size);
        origin = Grid.adjustPoint(origin);
        this.setBounds2D(origin.getX(), origin.getY(), size.getWidth(), size.getHeight());
        return true;
    }

    public void setLocation(Point2D centerPoint) {
        if (this.shape != null) {
            Dimension previousSize = this.shape.getBounds().getSize();
            Point2D newOrigin = this.getOriginFromCenter(centerPoint, previousSize);
            newOrigin = Grid.adjustPoint(newOrigin);
            this.setBounds2D(newOrigin.getX(), newOrigin.getY(), previousSize.getWidth(), previousSize.getHeight());
        }
    }

    public Point2D getOriginFromCenter(Point2D centerPoint, Dimension2D size) {
        double width = size.getWidth();
        double height = size.getHeight();
        double centerX = centerPoint.getX();
        double centerY = centerPoint.getY();
        double x0 = Math.max(0.0, centerX - width / 2.0);
        double y0 = Math.max(0.0, centerY - height / 2.0);
        return new Point2D.Double(x0, y0);
    }

    private boolean canComputeSize() {
        return this.algorithmNameView.getBounds2D().getWidth() != 0.0 && this.algorithmNameView.getBounds2D().getHeight() != 0.0;
    }

    private double getMinimumHeight() {
        double versionHeight;
        double height = 0.0;
        double nameHeight = this.algorithmNameView.getBounds2D().getHeight();
        if (nameHeight > 0.0) {
            height += nameHeight;
        }
        if (this.isVersionInfoVisible() && (versionHeight = this.algorithmVersionIdView.getBounds2D().getHeight()) > 0.0) {
            height += versionHeight;
        }
        height = Math.max(height, 36.0);
        return height;
    }

    private double getMinimumWidth() {
        double width = 0.0;
        double nameWidth = this.algorithmNameView.getBounds2D().getWidth();
        double versionWidth = 0.0;
        if (this.isVersionInfoVisible()) {
            versionWidth = this.algorithmVersionIdView.getBounds2D().getWidth();
        }
        width = Math.max(nameWidth, versionWidth);
        double minWidth = Math.max(72.0, width);
        return minWidth;
    }

    private double getImagesWidth() {
        double iconWidth = this.getIconDimension().getWidth();
        double decorationWidth = this.getDecorationDimension().getWidth();
        double imagesWidth = iconWidth + decorationWidth;
        if (iconWidth == 0.0 || decorationWidth == 0.0) {
            imagesWidth *= 2.0;
        }
        return imagesWidth;
    }

    private Dimension getDecorationDimension() {
        Dimension size = new Dimension(0, 0);
        if (this.decoration != null) {
            double h = Math.min(this.decoration.getHeight(), 25.0);
            double w = Math.min(this.decoration.getWidth(), 25.0);
            size.setSize(w, h);
        }
        return size;
    }

    private Dimension getIconDimension() {
        Dimension size = new Dimension(0, 0);
        if (this.icon != null) {
            double h = Math.min(this.icon.getHeight(), 25.0);
            double w = Math.min(this.icon.getWidth(), 25.0);
            size.setSize(w, h);
        }
        return size;
    }

    private void createCornerPoints() {
        Rectangle2D boundBox = this.shape.getBounds2D();
        this.cornerViews = new GraphPoint[4];
        this.cornerViews[0] = new GraphPoint(boundBox.getX(), boundBox.getY());
        this.cornerViews[1] = new GraphPoint(boundBox.getX() + boundBox.getWidth(), boundBox.getY());
        this.cornerViews[2] = new GraphPoint(boundBox.getX() + boundBox.getWidth(), boundBox.getY() + boundBox.getHeight());
        this.cornerViews[3] = new GraphPoint(boundBox.getX(), boundBox.getY() + boundBox.getHeight());
    }

    private void createInputFileTypes() {
        GraphFileDescriptor graphFileDescriptor;
        this.inputFileTypeViews = new ArrayList<GraphFileDescriptor>();
        for (InputFileParameter inputFileParameter : this.configuratorView.getConfigurator().getInputFileParameters()) {
            if (!inputFileParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.TRUE) && !inputFileParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) continue;
            graphFileDescriptor = new GraphFileDescriptor((AbstractFileParameter)inputFileParameter, this);
            this.inputFileTypeViews.add(graphFileDescriptor);
        }
        for (InputURLParameter inputURLParameter : this.configuratorView.getConfigurator().getInputURLParameters()) {
            if (!inputURLParameter.getMode().equals((Object)FileParameterMode.REGULAR_FILE) && !inputURLParameter.getMode().equals((Object)FileParameterMode.DIRECTORY) || !inputURLParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.TRUE) && !inputURLParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) continue;
            graphFileDescriptor = new GraphFileDescriptor((AbstractFileParameter)inputURLParameter, this);
            this.inputFileTypeViews.add(graphFileDescriptor);
        }
    }

    private void createOutputFileTypes() {
        GraphFileDescriptor graphFileDescriptor;
        this.outputFileTypeViews = new ArrayList<GraphFileDescriptor>();
        for (OutputFileParameter outputFileParameter : this.configuratorView.getConfigurator().getOutputFileParameters()) {
            if (outputFileParameter.isLogFile() || !outputFileParameter.getMode().equals((Object)FileParameterMode.REGULAR_FILE) && !outputFileParameter.getMode().equals((Object)FileParameterMode.DIRECTORY) || !outputFileParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.TRUE) && !outputFileParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) continue;
            graphFileDescriptor = new GraphFileDescriptor((AbstractFileParameter)outputFileParameter, this);
            this.outputFileTypeViews.add(graphFileDescriptor);
        }
        for (OutputURLParameter outputURLParameter : this.configuratorView.getConfigurator().getOutputURLParameters()) {
            if (!outputURLParameter.getMode().equals((Object)FileParameterMode.REGULAR_FILE) && !outputURLParameter.getMode().equals((Object)FileParameterMode.DIRECTORY) || !outputURLParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.TRUE) && !outputURLParameter.usesPipe().equals((Object)FileParameterPipeAcceptance.ALWAYS)) continue;
            graphFileDescriptor = new GraphFileDescriptor((AbstractFileParameter)outputURLParameter, this);
            this.outputFileTypeViews.add(graphFileDescriptor);
        }
    }

    private void createShape() {
        double w = this.dimension.getWidth();
        double h = this.dimension.getHeight();
        double x = this.northWestPoint.getX();
        double y = this.northWestPoint.getY();
        double arc = Math.min(w, h) * 0.3;
        double dx = w * 0.07499999999999996;
        double dy = h * 0.07499999999999996;
        double d = Math.min(dx, dy);
        this.shape = new RoundRectangle2D.Double(x, y, w, h, arc, arc);
        this.shadowShape = new RoundRectangle2D.Double(x + d, y + d, w, h, arc, arc);
        this.createCornerPoints();
    }

    private Rectangle2D getBoundsFileTypes(Collection<GraphFileDescriptor> fileTypeCollection) {
        Rectangle2D bounds = this.shape.getBounds2D();
        for (GraphFileDescriptor fileType : fileTypeCollection) {
            bounds = bounds.createUnion(fileType.getBounds2D());
        }
        return bounds;
    }

    private Point2D getCenterPoint() {
        Point centerPoint = new Point();
        ((Point2D)centerPoint).setLocation(this.getBounds2D().getCenterX(), this.getBounds2D().getCenterY());
        return centerPoint;
    }

    private Point2D getFirstPoint() {
        Point firstPoint = new Point();
        ((Point2D)firstPoint).setLocation(this.shape.getBounds2D().getMinX(), this.shape.getBounds2D().getMinY());
        return firstPoint;
    }

    private boolean handlePickNodeMessage(PickNodeMessage message) {
        if (!this.contains(message.getPoint())) {
            return false;
        }
        message.setNode(this);
        return true;
    }

    private boolean handleShowParameterValuesMessage() {
        if (this.isSelected()) {
            this.showParameterValues();
            return true;
        }
        return false;
    }

    private boolean handlePasteMessage(PasteMessage pasteMessage) {
        ParametersTransferable parametersTransferable;
        CopyAndPasteOperation operation;
        OperationStatus status;
        if (!this.isSelected()) {
            return false;
        }
        Transferable transferable = pasteMessage.getTransferable();
        if (transferable instanceof ParametersTransferable && (status = (operation = new CopyAndPasteOperation(parametersTransferable = (ParametersTransferable)transferable, this)).execute()).isConfirmed()) {
            if (status.hasWarnings() || status.hasErrors()) {
                this.askForParameterValues();
            }
            pasteMessage.setAffectedElement(this);
        }
        return true;
    }

    private GraphFileDescriptor pickFileType(Point2D pt) {
        GraphFileDescriptor fileType = this.pickFileType(pt, this.outputFileTypeViews);
        if (fileType != null) {
            return fileType;
        }
        return this.pickFileType(pt, this.inputFileTypeViews);
    }

    private GraphFileDescriptor pickFileType(Point2D pt, Collection<GraphFileDescriptor> fileTypeCollection) {
        for (GraphFileDescriptor fileType : fileTypeCollection) {
            if (fileType.pick(pt) == null) continue;
            return fileType;
        }
        return null;
    }

    private void resizeEast(Point2D pt) {
        double minWidth;
        Rectangle2D bounds = this.shape.getBounds2D();
        double newX = pt.getX();
        double eastX = bounds.getMaxX();
        double x = bounds.getMinX();
        double y = bounds.getMinY();
        double height = bounds.getHeight();
        double width = bounds.getWidth();
        double newWidth = width + newX - eastX;
        if (newWidth < (minWidth = 72.0 + this.getImagesWidth())) {
            newWidth = minWidth;
        }
        this.setBounds2D(x, y, newWidth, height);
    }

    private void resizeNorth(Point2D pt) {
        double minHeight;
        Rectangle2D bounds = this.shape.getBounds2D();
        double x = bounds.getMinX();
        double northY = bounds.getMinY();
        double newY = pt.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double newHeight = height + northY - newY;
        if (newHeight < (minHeight = this.getMinimumHeight())) {
            newY = bounds.getMaxY() - minHeight;
            newHeight = minHeight;
        }
        this.setBounds2D(x, newY, width, newHeight);
    }

    private void resizeNorthEast(Point2D pt) {
        this.resizeNorth(pt);
        this.resizeEast(pt);
    }

    private void resizeNorthWest(Point2D pt) {
        this.resizeNorth(pt);
        this.resizeWest(pt);
    }

    private void resizeSouth(Point2D pt) {
        double minHeight;
        Rectangle2D bounds = this.shape.getBounds2D();
        double x = bounds.getMinX();
        double y = bounds.getMinY();
        double newY = pt.getY();
        double southY = bounds.getMaxY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double newHeight = height + newY - southY;
        if (newHeight < (minHeight = this.getMinimumHeight())) {
            newHeight = minHeight;
        }
        this.setBounds2D(x, y, width, newHeight);
    }

    private void resizeSouthEast(Point2D pt) {
        this.resizeSouth(pt);
        this.resizeEast(pt);
    }

    private void resizeSouthWest(Point2D pt) {
        this.resizeSouth(pt);
        this.resizeWest(pt);
    }

    private void resizeWest(Point2D pt) {
        double minWidth;
        Rectangle2D bounds = this.shape.getBounds2D();
        double newX = pt.getX();
        double westX = bounds.getMinX();
        double y = bounds.getMinY();
        double height = bounds.getHeight();
        double width = bounds.getWidth();
        double newWidth = width + westX - newX;
        if (newWidth < (minWidth = 72.0 + this.getImagesWidth())) {
            newWidth = minWidth;
            newX = bounds.getMaxX() - minWidth;
        }
        this.setBounds2D(newX, y, newWidth, height);
    }

    protected void setBounds2D(double xBnd, double yBnd, double wBnd, double hBnd) {
        double imagesWidth = this.getImagesWidth();
        double width = Math.max(wBnd, 72.0 + this.getImagesWidth());
        double height = Math.max(hBnd, 36.0);
        double x = Math.max(xBnd, 0.0);
        double y = Math.max(yBnd, 0.0);
        Rectangle2D.Double rect = new Rectangle2D.Double(xBnd, yBnd, wBnd, hBnd);
        Rectangle2D newBounds = Grid.adjustBounds(rect);
        x = newBounds.getMinX();
        y = newBounds.getMinY();
        width = newBounds.getWidth();
        height = newBounds.getHeight();
        this.northWestPoint = new Point();
        this.northWestPoint.setLocation(x, y);
        this.dimension = new Dimension();
        this.dimension.setSize(width, height);
        if (this.icon != null || this.decoration != null) {
            this.updateImages();
        }
        this.createShape();
        this.updateFileTypes();
        this.adjustFileTypes();
        double maxTextWidth = width - imagesWidth;
        this.algorithmNameView.setMaxWidth(maxTextWidth);
        this.algorithmVersionIdView.setMaxWidth(maxTextWidth);
        this.updateTextLocation();
        this.repaint();
    }

    private void setListeners() {
        this.getGraph().addGraphListener(new GraphListener(){

            @Override
            public void wasChangedWorkspace(Graph graph) {
            }

            @Override
            public void wasElementCreated(Graph graph, GraphElement element) {
            }

            @Override
            public void wasElementDragged(Graph graph, GraphElement element, double tx, double ty) {
            }

            @Override
            public void wasElementDragged(Graph graph, GraphElement element, Point2D startPoint, Point2D endPoint) {
            }

            @Override
            public void wasElementDropped(Graph graph, GraphElement element, Point2D pt) {
            }

            @Override
            public void wasElementParametrized(Graph graph, GraphElement element) {
            }

            @Override
            public void wasElementRemoved(Graph graph, GraphElement element) {
            }

            @Override
            public void wasElementSelected(Graph graph, GraphElement element) {
            }

            @Override
            public void wasLinkIncreased(Graph graph, GraphLink link) {
            }

            @Override
            public void wasNodeResized(Graph graph, GraphNode node) {
            }

            @Override
            public void wasParameterSetEnabled(Graph graph, GraphNode node, String parameterName, boolean isEnabled) {
            }

            @Override
            public void wasReseted(Graph graph) {
            }

            @Override
            public void wasParameterSetVisible(Graph graph, GraphNode node, String parameterName, boolean isVisible) {
            }

            @Override
            public void wasLinkAnchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
                GraphNode.this.validateIfLinkedTo(link);
            }

            @Override
            public void wasLinkStatusChanged(Graph graph, GraphLink link) {
                GraphNode.this.validateIfLinkedTo(link);
            }

            @Override
            public void wasLinkUnanchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
                GraphNode.this.validateIfLinkedTo(link);
            }
        });
        this.configuratorView.addAlgorithmConfiguratorViewListener(new AlgorithmConfiguratorViewListener(){

            @Override
            public void wasConfirmed(AlgorithmConfiguratorView view) {
                for (GraphElementListener listener : GraphNode.this.getListenerList()) {
                    listener.wasParametrized(GraphNode.this);
                }
            }

            @Override
            public void wasCancelled(AlgorithmConfiguratorView view) {
            }
        });
        AlgorithmConfigurator algorithmConfigurator = this.configuratorView.getConfigurator();
        algorithmConfigurator.addAlgorithmConfiguratorListener(new AlgorithmConfiguratorListener(){

            public void parameterLabelWasChanged(AlgorithmConfigurator configurator, String name, String label) {
            }

            public void parameterWasSetEnabled(AlgorithmConfigurator configurator, String parameterName, boolean parameterIsEnabled) {
                GraphNode.this.fullValidation();
                for (GraphElementListener listener : GraphNode.this.getListenerList()) {
                    listener.wasParameterSetEnabled(GraphNode.this, parameterName, parameterIsEnabled);
                }
            }

            public void parameterWasSetVisible(AlgorithmConfigurator configurator, String parameterName, boolean parameterIsVisible) {
                GraphNode.this.fullValidation();
                for (GraphElementListener listener : GraphNode.this.getListenerList()) {
                    listener.wasParameterSetVisible(GraphNode.this, parameterName, parameterIsVisible);
                }
            }

            public <V> void parameterValueWasChanged(AlgorithmConfigurator configurator, String parameterName, V parameterValue) {
                GraphNode.this.fullValidation();
            }

            public void wasSetEnabled(AlgorithmConfigurator configurator) {
            }
        });
    }

    private void validateIfLinkedTo(GraphLink link) {
        GraphNode endNode = link.getEndNode();
        if (endNode != null && this.getId() == endNode.getId()) {
            this.fullValidation();
            return;
        }
        GraphNode startNode = link.getStartNode();
        if (startNode != null && this.getId() == startNode.getId()) {
            this.fullValidation();
        }
    }

    private void setUpVix() {
        Object image;
        this.changeVO(null, (TypeVO)this.algorithmNameView);
        this.algorithmNameView.changeVS(null, (TypeVS)this);
        this.changeVO(null, (TypeVO)this.algorithmVersionIdView);
        this.algorithmVersionIdView.changeVS(null, (TypeVS)this);
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            this.changeVO(null, (TypeVO)inputFileType);
            inputFileType.changeVS(null, (TypeVS)this);
        }
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            this.changeVO(null, (TypeVO)outputFileType);
            outputFileType.changeVS(null, (TypeVS)this);
        }
        if (this.icon != null) {
            this.changeVO(null, (TypeVO)this.icon);
            this.icon.changeVS(null, (TypeVS)this);
        }
        if (this.decoration != null && (image = this.decoration.getVO()) != null) {
            this.changeVO(null, (TypeVO)image);
            image.changeVS(null, (TypeVS)this);
        }
    }

    private boolean isContainedInRectangle(double x1, double y1, double x2, double y2, Point2D pt) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        bounds.setFrameFromDiagonal(x1, y1, x2, y2);
        return bounds.contains(pt);
    }

    private void updateFileTypes() {
        this.updateInputFileTypes();
        this.updateOutputFileTypes();
    }

    private void updateIconLocation() {
        if (this.icon != null) {
            Dimension iconDimension = this.getIconDimension();
            double h = iconDimension.getHeight();
            double w = iconDimension.getWidth();
            double origH = this.dimension.getHeight();
            double deltaH = origH - h;
            double x = this.northWestPoint.getX();
            double y = this.northWestPoint.getY() + deltaH;
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
            this.icon.setRectangle(rect);
        }
    }

    private void updateImages() {
        this.updateIconLocation();
        this.updateDecorationLocation();
    }

    private void updateDecorationLocation() {
        if (this.decoration != null) {
            Dimension decorationDimension = this.getDecorationDimension();
            double h = decorationDimension.getHeight();
            double w = decorationDimension.getWidth();
            double origH = this.dimension.getHeight();
            double origW = this.dimension.getWidth();
            double deltaH = origH - h;
            double deltaW = origW - w;
            double x = this.northWestPoint.getX() + deltaW;
            double y = this.northWestPoint.getY() + deltaH;
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
            this.decoration.setRectangle(rect);
        }
    }

    private void updateInputFileTypes() {
        if (this.inputFileTypeViews == null) {
            this.createInputFileTypes();
        }
        Rectangle2D bounds = this.shape.getBounds2D();
        double leftX = bounds.getMinX();
        double rightX = bounds.getMaxX();
        double upperY = bounds.getMinY();
        double inputInterval = (rightX - leftX) / ((double)this.inputFileTypeViews.size() + 1.0);
        double x = leftX;
        for (GraphFileDescriptor inputFileType : this.inputFileTypeViews) {
            Point pt = new Point();
            ((Point2D)pt).setLocation(x += inputInterval, upperY);
            inputFileType.setLocation(pt);
        }
    }

    private void updateOutputFileTypes() {
        if (this.outputFileTypeViews == null) {
            this.createOutputFileTypes();
        }
        Rectangle2D bounds = this.shape.getBounds2D();
        double leftX = bounds.getMinX();
        double rightX = bounds.getMaxX();
        double lowerY = bounds.getMaxY();
        double outputInterval = (rightX - leftX) / ((double)this.outputFileTypeViews.size() + 1.0);
        double x = leftX;
        for (GraphFileDescriptor outputFileType : this.outputFileTypeViews) {
            Point pt = new Point();
            ((Point2D)pt).setLocation(x += outputInterval, lowerY);
            outputFileType.setLocation(pt);
        }
    }

    private void updateTextLocation() {
        double centerX = this.getCenterPoint().getX();
        double y = this.northWestPoint.getY();
        if (this.isVersionInfoVisible()) {
            double nameHeight = this.algorithmNameView.getBounds2D().getHeight();
            double versionHeight = this.algorithmVersionIdView.getBounds2D().getHeight();
            double inset = y + (this.dimension.getHeight() - nameHeight - versionHeight) / 2.0;
            double nameCenterY = inset + nameHeight / 2.0;
            this.algorithmNameView.setLocation(centerX, nameCenterY);
            double versionCenterY = inset + nameHeight + versionHeight / 2.0;
            this.algorithmVersionIdView.setLocation(centerX, versionCenterY);
        } else {
            this.algorithmNameView.setLocation(centerX, y + this.dimension.getHeight() / 2.0);
        }
    }

    private ViewValidationResult validateAlgorithmConfigurator(ValidationMode mode) {
        ViewValidationResult validation = ViewValidationTask.runTask(this.getGraph().getParentWindow(), this.configuratorView, mode, false);
        return validation;
    }

    private ViewValidationResult validateInputFiles() {
        for (GraphFileDescriptor descriptor : this.inputFileTypeViews) {
            GraphLink link;
            if (!descriptor.validate()) {
                LocalizedMessage message = new LocalizedMessage(GraphNode.class, "error_invalid_input_file_descriptor", new Object[]{descriptor.toString()});
                return new ViewValidationResult(message, (ViewValidator)this);
            }
            if (!descriptor.getFileParameter().isEnabled() || (link = descriptor.getLinkTo()) == null || link.isWellFormed()) continue;
            LocalizedMessage message = new LocalizedMessage(GraphNode.class, "error_invalid_link", new Object[]{link.toString()});
            return new ViewValidationResult(message, (ViewValidator)this);
        }
        return new ViewValidationResult(this);
    }

    private ViewValidationResult validateOutputFiles() {
        for (GraphFileDescriptor descriptor : this.outputFileTypeViews) {
            if (!descriptor.validate()) {
                LocalizedMessage message = new LocalizedMessage(GraphNode.class, "error_invalid_output_file_descriptor", new Object[]{descriptor.toString()});
                return new ViewValidationResult(message, (ViewValidator)this);
            }
            if (!descriptor.getFileParameter().isEnabled()) continue;
            for (GraphLink link : descriptor.getLinkFromCollection()) {
                if (link.isWellFormed()) continue;
                LocalizedMessage message = new LocalizedMessage(GraphNode.class, "error_invalid_link", new Object[]{link.toString()});
                return new ViewValidationResult(message, (ViewValidator)this);
            }
        }
        return new ViewValidationResult(this);
    }

    public boolean setBypassed(boolean bypassed) {
        this.validateBypass();
        if (!bypassed || this.canBypass) {
            this.bypassed = bypassed;
            ViewValidationResult result = this.validate(ValidationMode.FULL);
            this.highlightValidationResult(result);
            this.updateFileTypes();
            return true;
        }
        return false;
    }

    public boolean isBypassed() {
        return this.bypassed;
    }

    public boolean canBeBypassed() {
        return this.canBypass;
    }

    protected void validateBypass() {
        Collection<GraphLink> linkFromCollection = this.getLinkFromCollection();
        Collection<GraphLink> linkToCollection = this.getLinkToCollection();
        if (this.inputFileTypeViews.size() == this.outputFileTypeViews.size() && linkFromCollection.size() > 0 && linkToCollection.size() > 0 && this.isEquivalent(linkFromCollection, linkToCollection)) {
            this.canBypass = true;
            return;
        }
        this.canBypass = false;
    }

    protected boolean isEquivalent(Collection<GraphLink> linkFromCollection, Collection<GraphLink> linkToCollection) {
        Map<String, Integer> linkToTypeCount = this.getLinkToTypeCount(linkToCollection);
        Map<String, Integer> linkFromTypeCount = this.getLinkFromTypeCount(linkFromCollection);
        if (linkToTypeCount.keySet().size() == linkFromTypeCount.keySet().size()) {
            for (String type : linkToTypeCount.keySet()) {
                if (linkToTypeCount.get(type).equals(linkFromTypeCount.get(type))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Map<String, Integer> getLinkFromTypeCount(Collection<GraphLink> linkFromCollection) {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        ArrayList<GraphFileDescriptor> outputs = new ArrayList<GraphFileDescriptor>();
        for (GraphLink linkFrom : linkFromCollection) {
            Integer typeCount;
            GraphFileDescriptor outputFileDescriptor;
            GraphFileDescriptor inputFileDescriptor = linkFrom.getInputFileDescriptor();
            if (inputFileDescriptor == null) continue;
            String outputFileType = "NOT_SPECIFIED";
            AbstractFileParameter fileParameter = inputFileDescriptor.getFileParameter();
            if (fileParameter != null && fileParameter.getFileTypes() != null && fileParameter.getFileTypes().length == 1) {
                outputFileType = fileParameter.getFileTypes()[0];
            }
            if ((outputFileDescriptor = linkFrom.getOutputFileDescriptor()) == null || outputs.contains((Object)outputFileDescriptor)) continue;
            outputs.add(outputFileDescriptor);
            if (types.get(outputFileType) == null) {
                types.put(outputFileType, 1);
                continue;
            }
            Integer n = typeCount = (Integer)types.get(outputFileType);
            Integer n2 = typeCount = Integer.valueOf(typeCount + 1);
            types.put(outputFileType, n);
        }
        return types;
    }

    protected Map<String, Integer> getLinkToTypeCount(Collection<GraphLink> linkToCollection) {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        for (GraphLink linkTo : linkToCollection) {
            Integer typeCount;
            GraphFileDescriptor outputFileDescriptor = linkTo.getOutputFileDescriptor();
            if (outputFileDescriptor == null) continue;
            AbstractFileParameter fileParameter = outputFileDescriptor.getFileParameter();
            String inpuFileType = "NOT_SPECIFIED";
            if (fileParameter != null && fileParameter.getFileTypes() != null && fileParameter.getFileTypes().length == 1) {
                inpuFileType = fileParameter.getFileTypes()[0];
            }
            if (types.get(inpuFileType) == null) {
                types.put(inpuFileType, 1);
                continue;
            }
            Integer n = typeCount = (Integer)types.get(inpuFileType);
            Integer n2 = typeCount = Integer.valueOf(typeCount + 1);
            types.put(inpuFileType, n);
        }
        return types;
    }

    public void addImageDecoration(GraphNodeImageDecoration.DecorationType type) {
        GraphNodeDecoration<SVGVO> newDecoration = GraphNodeImageDecoration.createDecoration(type);
        this.replaceDecoration(newDecoration);
    }

    public void addTextDecoration(String text, String description) {
        this.replaceDecoration(new GraphNodeTextDecoration(this.getVS(), text, description));
    }

    public void removeDecoration() {
        this.replaceDecoration(new GraphNodeImageDecoration());
    }

    private void replaceDecoration(GraphNodeDecoration<?> newDecoration) {
        Object image;
        if (this.decoration != null && (image = this.decoration.getVO()) != null) {
            image.changeVS((TypeVS)this, null);
            this.changeVO((TypeVO)image, null);
        }
        this.decoration = newDecoration;
        if (this.decoration != null && (image = this.decoration.getVO()) != null) {
            image.changeVS(null, (TypeVS)this);
            this.changeVO(null, (TypeVO)image);
        }
        this.adjustTextPadding();
        this.updateImages();
        this.layoutChanged = true;
        this.repaint();
    }

    @Override
    public boolean highlightValidationResult(ViewValidationResult result) {
        this.backgroundColor = this.isWellFormed() ? (result.isWellSucceded() ? READY_BACKGROUND_COLOR : NOT_READY_BACKGROUND_COLOR) : ERROR_COLOR;
        if (this.isBypassed() && this.canBeBypassed()) {
            this.algorithmNameView.setColor(BYPASSED_TEXT_COLOR);
            this.algorithmVersionIdView.setColor(BYPASSED_TEXT_COLOR);
        } else {
            this.algorithmNameView.setColor(DEFAULT_FOREGROUNG_COLOR);
            this.algorithmVersionIdView.setColor(DEFAULT_FOREGROUNG_COLOR);
        }
        this.repaint();
        return true;
    }

    public void setVersionInfoVisible(boolean visible) {
        this.algorithmVersionIdView.setVisible(visible);
        this.layoutChanged = true;
        this.repaint();
    }

    protected boolean isVersionInfoVisible() {
        return this.algorithmVersionIdView.isVisible();
    }

    @Override
    protected void translate(Point2D pt) {
        Rectangle2D bounds2d = this.shape.getBounds2D();
        double newX = bounds2d.getX() + pt.getX();
        double newY = bounds2d.getY() + pt.getY();
        this.setBounds2D(newX, newY, bounds2d.getWidth(), bounds2d.getHeight());
    }
}

