/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.Utilities;
import java.awt.Window;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;

public class FileTextField {
    private JLabel label;
    private JTextField field;
    private JButton button;
    private boolean complain = true;
    private CommonClientProject project;
    private String extension;
    private int mode;
    private Window window;
    private boolean isSaveMode;

    public JTextField getField() {
        return this.field;
    }

    public String getText() {
        return this.field.getText();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JButton getButton() {
        return this.button;
    }

    public ProjectTreePath getButtonPath() throws ClientException {
        ProjectFileChooser chooser = this.isSaveMode ? new ProjectFileChooserSave(this.window, this.project, this.mode, this.extension) : new ProjectFileChooserOpen(this.window, this.project, false, this.mode, this.extension);
        return chooser.getSelectedPath();
    }

    public ProjectTreePath[] getButtonPaths() throws ClientException {
        ProjectFileChooser chooser = this.isSaveMode ? new ProjectFileChooserSave(this.window, this.project, this.mode, this.extension) : new ProjectFileChooserOpen(this.window, this.project, false, this.mode, this.extension);
        return chooser.getSelectedPaths();
    }

    private ClientProjectFile retrieveFile(String textPath, final ClientProjectFile dir) throws ClientException {
        final String[] simplePath = Utilities.splitProjectPath((String)textPath);
        if (simplePath == null) {
            throw new ClientException("UTIL_INVALID_PATH");
        }
        RemoteTask<ClientProjectFile> task = new RemoteTask<ClientProjectFile>(){

            public void performTask() throws Exception {
                ClientProjectFile d = dir;
                for (int i = 0; i < simplePath.length - 1; ++i) {
                    String pth = simplePath[i];
                    if ((d = d.getChild(pth)) != null && d.isDirectory()) continue;
                    throw new ClientException("UTIL_INVALID_PATH");
                }
                String lastPath = simplePath[simplePath.length - 1];
                this.setResult(d.getChild(lastPath));
            }
        };
        task.execute(null, "", "");
        Exception e = task.getError();
        if (e instanceof ClientException) {
            throw (ClientException)e;
        }
        return (ClientProjectFile)task.getResult();
    }

    private String[] makeFilePath(String textPath, ClientProjectFile dir) throws RemoteException {
        String[] simplePath = Utilities.splitProjectPath((String)textPath);
        String[] rootPath = dir.getPath();
        String[] filePath = new String[rootPath.length + simplePath.length];
        System.arraycopy(rootPath, 0, filePath, 0, rootPath.length);
        for (int i = 0; i < simplePath.length - 1; ++i) {
            dir = dir.getChild(simplePath[i]);
            filePath[rootPath.length + i] = simplePath[i];
        }
        filePath[filePath.length - 1] = simplePath[simplePath.length - 1];
        String fileName = filePath[filePath.length - 1];
        if (fileName.indexOf(".") == -1 && this.extension != null) {
            filePath[filePath.length - 1] = fileName + "." + this.extension.toLowerCase();
        }
        return filePath;
    }

    private ProjectTreePath getDirectoryPath(String textPath) {
        ClientProjectFile dir = this.project.getRoot();
        if (textPath.equals("/")) {
            return new ProjectTreePath(dir);
        }
        ClientProjectFile file = null;
        try {
            file = this.retrieveFile(textPath, dir);
        }
        catch (ClientException e) {
            this.signalError(e.getMessage());
            return null;
        }
        if (file != null) {
            if (!file.isDirectory()) {
                this.signalError("UTIL_NOT_A_DIRECTORY", file.getName());
                return null;
            }
            return new ProjectTreePath(file);
        }
        this.signalError("UTIL_INVALID_DIR_PATH");
        return null;
    }

    private ProjectTreePath openFilePath(String textPath) {
        ClientProjectFile dir = this.project.getRoot();
        if (textPath.equals("/")) {
            this.signalError("UTIL_UNSPECIFIED_FILE");
            return null;
        }
        ClientProjectFile file = null;
        try {
            file = this.retrieveFile(textPath, dir);
        }
        catch (ClientException e) {
            this.signalError(e.getMessage());
            return null;
        }
        if (file != null) {
            if (file.isDirectory()) {
                this.signalError("UTIL_NOT_A_FILE", file.getName());
                return null;
            }
            return new ProjectTreePath(file);
        }
        this.signalError("UTIL_INVALID_PATH");
        return null;
    }

    private void signalError(String errorKey) {
        this.signalError(errorKey, null);
    }

    private void signalError(String errorKey, String param) {
        if (this.complain) {
            String error = LNG.get((String)errorKey);
            if (param != null) {
                Object[] params = new Object[]{param};
                error = MessageFormat.format(error, params);
            }
            ClientUtilities.showErrorByTextField(null, error, this.getLabel(), this.getField());
        }
    }

    public ProjectTreePath getFieldPath() {
        ProjectTreePath path = null;
        String trimmedText = this.getField().getText().trim();
        if (FileTextField.isEmpty(trimmedText)) {
            if (this.mode == 1) {
                this.signalError("UTIL_UNSPECIFIED_DIR");
            } else {
                this.signalError("UTIL_UNSPECIFIED_FILE");
            }
            return null;
        }
        if (!ClientUtilities.validatePathChars(trimmedText)) {
            this.signalError("UTIL_CHARACTER_ERROR");
            return null;
        }
        switch (this.mode) {
            case 1: {
                path = this.getDirectoryPath(trimmedText);
                break;
            }
            case 0: {
                if (this.isSaveMode) {
                    path = this.saveFilePath(trimmedText);
                    break;
                }
                path = this.openFilePath(trimmedText);
                break;
            }
            default: {
                return null;
            }
        }
        return path;
    }

    private ProjectTreePath saveFilePath(final String textPath) {
        if (textPath.equals("/")) {
            this.signalError("UTIL_UNSPECIFIED_FILE");
            return null;
        }
        final ClientProjectFile dir = this.project.getRoot();
        ClientProjectFile file = null;
        try {
            file = this.retrieveFile(textPath, dir);
        }
        catch (ClientException e) {
            this.signalError(e.getMessage());
            return null;
        }
        if (file != null) {
            if (file.isDirectory()) {
                this.signalError("UTIL_NOT_A_FILE", file.getName());
                return null;
            }
            return new ProjectTreePath(file);
        }
        RemoteTask<String[]> task = new RemoteTask<String[]>(){

            public void performTask() throws RemoteException {
                String[] filePath = FileTextField.this.makeFilePath(textPath, dir);
                this.setResult(filePath);
            }
        };
        task.execute(this.window, null, null);
        if (!task.getStatus()) {
            return null;
        }
        String[] filePath = (String[])task.getResult();
        return new ProjectTreePath(filePath, dir);
    }

    private static boolean isEmpty(String text) {
        return text == null || text.equals("");
    }

    public FileTextField(Window window, String labelText, int fieldLength, CommonClientProject project, int mode, boolean isSaveMode) {
        this.project = project;
        this.window = window;
        this.mode = mode;
        this.isSaveMode = isSaveMode;
        this.label = new JLabel();
        if (labelText != null) {
            this.label.setText(labelText);
        }
        this.field = new JTextField(fieldLength);
        this.button = ClientUtilities.createImageButton(ApplicationImages.ICON_BROWSEFILE_24);
        this.field = new JTextField(fieldLength);
    }

    public void setSaveMode(boolean isSaveMode) {
        this.isSaveMode = isSaveMode;
    }

    public FileTextField(Window window, String labelText, int fieldLength, CommonClientProject project, int mode, String extension, boolean isSaveMode) {
        this(window, labelText, fieldLength, project, mode, isSaveMode);
        if (extension != null) {
            this.extension = extension.toUpperCase();
        }
    }
}

