package csbase.client.algorithms.parameters;

import csbase.logic.algorithms.parameters.TableColumn;

/**
 * Fbrica de {@link TableColumnView}.
 *
 * @author Tecgraf/PUC-Rio
 */
public interface TableColumnViewFactory {

  /**
   * Cria a viso da coluna.
   *
   * @param view A viso da tabela.
   *
   * @param column A coluna (No aceita {@code null}).
   *
   * @return A viso ou {@code null} se no for possvel encontrar uma viso
   *         adequada.
   */
  public TableColumnView<?, ? extends TableColumn<?>> create(
    TableParameterView view, TableColumn<?> column);
}