package csbase.client.applications.flowapplication.messages;

import java.awt.datatransfer.DataFlavor;

import tecgraf.vix.Message;
import tecgraf.vix.TypeVS;

/**
 * Mensagem utilizada para perguntar se a rea de transferncia contm um objeto
 * de um determinado tipo.
 */
public final class CheckClipboardFlavorMessage extends Message {

  /**
   * Indica se a rea de transferncia contm um objeto do tipo especificado.
   */
  private Boolean supportsDataFlavor;

  /**
   * O tipo do objeto a ser testado.
   */
  private final DataFlavor flavor;

  /**
   * Construtor.
   * 
   * @param flavor o tipo do objeto.
   */
  public CheckClipboardFlavorMessage(DataFlavor flavor) {
    this.flavor = flavor;
  }

  /**
   * Indica se a rea de transferncia contm um objeto do tipo especificado.
   * 
   * @return {@code true} se tiver um objeto do tipo especificado, {@code false}
   *         se estiver vazia ou no tiver um objeto do tipo especificado.
   */
  public Boolean supportsDataFlavor() {
    return this.supportsDataFlavor;
  }

  /**
   * Response a pergunta
   * "A rea de transferncia contm um objeto do tipo especificado?"
   * 
   * @param supportsDataFlavor Indica se a rea de transferncia contm um
   *        objeto do tipo especificado.
   */
  public void setSupportsDataFlavor(final boolean supportsDataFlavor) {
    this.supportsDataFlavor = supportsDataFlavor;
  }

  /**
   * Obtm o tipo a ser testado.
   * 
   * @return o tipo.
   */
  public DataFlavor getFlavor() {
    return this.flavor;
  }

  /**
   * Testa se existe um objeto do {@link DataFlavor tipo} especificado
   * armazenado na rea de transferncia de um determinado VS.
   * 
   * @param vs VS a ser testado.
   * @param flavor o tipo de objeto a ser testado.
   * @return verdadeiro se a rea de transferncia contm um objeto com o tipo
   *         desejado ou falso, caso contenha um objeto de outro tipo ou esteja
   *         vazia.
   */
  public static boolean canPasteFromClipboard(final TypeVS vs, DataFlavor flavor) {
    final CheckClipboardFlavorMessage clipboardIsEmptyMessage =
      new CheckClipboardFlavorMessage(flavor);
    clipboardIsEmptyMessage.sendVS(vs);
    Boolean flavorIsSupported = clipboardIsEmptyMessage.supportsDataFlavor();
    if (flavorIsSupported == null) {
      flavorIsSupported = false;
    }
    return flavorIsSupported;
  }
}
