package csbase.client.applications.flowapplication.messages;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JComponent;

import tecgraf.vix.Message;

public final class ShowPopupMessage extends Message {
  private final Point2D point;
  private final List<JComponent> popupComponentList;

  public ShowPopupMessage(final Point2D point,
    final List<JComponent> popupComponentList) {
    this.point = (Point2D) point.clone();
    this.popupComponentList = new LinkedList<JComponent>(popupComponentList);
  }

  public Point2D getPoint() {
    return (Point2D) this.point.clone();
  }

  public List<JComponent> getPopupComponentList() {
    return Collections.unmodifiableList(this.popupComponentList);
  }
}
