package csbase.client.applications.flowapplication.multiflow.tree;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.NodeParameter;

/**
 * Renderizador dos ns da rvore como checkboxes para seleo.
 * 
 * @author Tecgraf
 */
public class ParameterSelectionCellRenderer extends JCheckBox implements
  TreeCellRenderer {

  /**
   * Modelo de seleo das checkboxes da rvore.
   */
  private ParameterSelectionModel selectionModel;

  /**
   * Renderizador dos ns da rvore.
   * 
   * @param selectionModel Modelo de seleo das checkboxes da rvore.
   */
  public ParameterSelectionCellRenderer(ParameterSelectionModel selectionModel) {
    this.selectionModel = selectionModel;
    setOpaque(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTreeCellRendererComponent(JTree tree, Object node,
    boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    if (node instanceof RootNode) {
      RootNode root = (RootNode) node;
      Flow flow = root.getUserObject();
      setText(flow.getName());
      setToolTipText(flow.getDescription());
    }
    else if (node instanceof AlgorithmNode) {
      AlgorithmNode algorithmNode = (AlgorithmNode) node;
      FlowNode flowNode = algorithmNode.getUserObject();
      setText(flowNode.getAlgorithmName());
      setToolTipText(node.toString());
    }
    else if (node instanceof ParameterNode) {
      ParameterNode parameterNode = (ParameterNode) node;
      ParameterSelection selection = parameterNode.getUserObject();
      NodeParameter parameter = selection.parameter;
      setText(parameter.getLabel());
      setToolTipText(parameter.toString());
    }

    TreePath path = tree.getPathForRow(row);
    if (path != null) {
      if (selectionModel.isPathSelected(path, true)) {
        setSelected(true);
      }
      else {
        setSelected(false);
      }
    }
    return this;
  }
}
