package csbase.client.applications.projectsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ProjectAreaOccupationDialog;

/**
 * Ao que abre dilogo de ocupao de espao em disco.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenProjectAreaOccupationDialogAction extends
  ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao
   */
  public OpenProjectAreaOccupationDialogAction(ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    ProjectsManager projectsManager = getProjectsManager();
    ProjectAreaOccupationDialog pod =
      new ProjectAreaOccupationDialog(projectsManager);
    pod.pack();
    //    pod.center();
    pod.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ProjectsManagerUI.DISK_USE;
  }
}
