package csbase.client.applications.projectsmanager.panels;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.renderers.ProjectListCellRenderer;

/**
 * Painel passado como "extra panel" para o dilogo de seleo de usurios
 * quando este  usado para compartilhamento de projetos.
 * 
 * @author jnlopes
 * 
 */
public class ProjectSharingInfoPanel extends ProjectsManagerPanel {

  /**
   * Lista de projetos selecionados.
   */
  private List<ProjectsManagerData> projectsManagerData;

  /**
   * boolean que indica se o nome do dono do projeto deve aparecer.
   */
  private final boolean displayOwner;

  /**
   * Indica que a borda do painel deve ser exibida.
   */
  private final boolean showTitledBorder;

  /**
   * Construtor. Exibir o frame em torno da lista.
   * 
   * @param projectsManager A aplicao
   * @param projectsManagerData A lista de projetos selecionados.
   * @param displayOwner boolean que indica se o nome do dono do projeto deve
   *        aparecer.
   */
  public ProjectSharingInfoPanel(final ProjectsManager projectsManager,
    final List<ProjectsManagerData> projectsManagerData,
    final boolean displayOwner) {
    this(projectsManager, projectsManagerData, displayOwner, true);
  }

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projectsManagerData A lista de projetos selecionados. (readonly /
   *        read-write).
   * @param displayOwner boolean que indica se o nome do dono do projeto deve
   *        aparecer.
   * @param showTitledBorder - indica que a borda do painel deve ser exibida
   */
  public ProjectSharingInfoPanel(final ProjectsManager projectsManager,
    final List<ProjectsManagerData> projectsManagerData,
    final boolean displayOwner, final boolean showTitledBorder) {
    super(projectsManager);
    this.projectsManagerData = projectsManagerData;
    this.displayOwner = displayOwner;
    this.showTitledBorder = showTitledBorder;

    buildPanel();
  }

  /**
   * Monta o painel.
   */
  private void buildPanel() {
    setLayout(new GridBagLayout());
    final DefaultListModel listModel = new DefaultListModel();

    for (ProjectsManagerData pmd : projectsManagerData) {
      listModel.addElement(pmd);
    }

    final JList list = new JList(listModel);
    list.setCellRenderer(new ProjectListCellRenderer(displayOwner));
    list.setVisibleRowCount(4);

    list.setVisible(true);
    list.setEnabled(true);
    list.validate();

    final JScrollPane listScrollPane = new JScrollPane(list);
    listScrollPane.setMinimumSize(new Dimension(400, 65));
    listScrollPane
      .setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

    final JPanel listPanel = new JPanel(new GridBagLayout());
    if (showTitledBorder) {
      BorderUtil.setTitledBorder(listPanel,
        getString("ProjectSharingInfoPanel.projects.text"));
    }

    final GBC gbc = new GBC(1, 0).horizontal().northwest();
    add(listScrollPane, gbc);
  }

}
