package csbase.client.util.xmlpanel;

import javax.swing.JPanel;

import org.w3c.dom.Node;

import tecgraf.javautils.core.lng.LNG;

/**
 * Painel abstrato para visualizao de dado XML (n).
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class XMLAbstractPanel extends JPanel {

  /**
   * N em exibio.
   */
  private Node node;

  /**
   * Retorna: n; conforme atributo {@link #node}.
   * 
   * @return o valor
   */
  public final Node getNode() {
    return node;
  }

  /**
   * Consulta uma string de internacionalizao.
   * 
   * @param tag tag
   * @return texto
   */
  protected String getString(String tag) {
    final String key = getClass().getSimpleName() + "." + tag;
    final String text = LNG.get(key);
    return text;
  }

  /**
   * Ajusta interno do valor do n (ver {@link #node}).
   * 
   * @param newNode o novo valor a ser ajustado
   */
  protected final void internalSetNode(Node newNode) {
    this.node = newNode;
  }

  /**
   * Setter padro para ajuste intero do n (conforme defino de:
   * {@link #internalSetNode(Node)}).
   * 
   * @param node novo n
   */
  abstract public void setNode(Node node);
}
