/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.actions;

import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphElementAction;
import csbase.client.desktop.DesktopComponentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class LabelAction
extends GraphElementAction {
    private GraphNode currentNode;
    Workspace workspace;
    JTextField nameField;

    public LabelAction(GraphNode element, Workspace workspace) {
        super(element, LabelAction.class.getName() + ".name", FlowApplicationUI.LABEL_ICON);
        this.workspace = workspace;
        this.currentNode = element;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DesktopComponentDialog newNameDialog = new DesktopComponentDialog(this.workspace.getGraph().getParentWindow(), this.getDialogTitle());
        newNameDialog.setDefaultCloseOperation(2);
        newNameDialog.setContentPane(this.createPane(newNameDialog));
        newNameDialog.pack();
        newNameDialog.setLocationRelativeTo(this.workspace);
        newNameDialog.setResizable(false);
        newNameDialog.setVisible(true);
    }

    private String getDialogTitle() {
        String className = LabelAction.class.getName();
        return MessageFormat.format(LNG.get((String)(className + ".title")), this.currentNode.getAlgorithmName());
    }

    private JPanel createPane(final DesktopComponentDialog dialog) {
        String className = LabelAction.class.getName();
        JLabel nameLabel = new JLabel(LNG.get((String)(className + ".new.label")));
        this.nameField = new JTextField(25);
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    LabelAction.this.changesName(dialog);
                }
            }
        });
        this.nameField.setText(this.currentNode.getAlgorithmTitle());
        this.nameField.selectAll();
        JPanel paramsPanel = GUIUtils.createBasicGridPanel((JComponent[][])new JComponent[][]{{nameLabel, this.nameField}});
        String restoreText = LNG.get((String)(className + ".button.restore.label"));
        String restoreTip = LNG.get((String)(className + ".button.restore.tooltip"));
        JButton restoreButton = new JButton(restoreText);
        restoreButton.addActionListener(e -> this.restoreName(dialog));
        restoreButton.setEnabled(this.currentNode.getLabel() != null);
        restoreButton.setToolTipText(restoreTip);
        String okText = LNG.get((String)(className + ".button.ok"));
        JButton okButton = new JButton(okText);
        okButton.addActionListener(e -> this.changesName(dialog));
        String cancelText = LNG.get((String)(className + ".button.cancel"));
        JButton cancelButton = new JButton(cancelText);
        cancelButton.addActionListener(e -> dialog.close());
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{okButton, cancelButton, restoreButton});
        buttonsPanel.add((Component)restoreButton, new GBC(0, 0).west().insets(0, 0, 0, 5));
        buttonsPanel.add((Component)okButton, new GBC(1, 0).center().insets(0, 15, 0, 5));
        buttonsPanel.add((Component)cancelButton, new GBC(2, 0).east().insets(0, 5, 0, 0));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)paramsPanel, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        return mainPanel;
    }

    private void restoreName(DesktopComponentDialog dialog) {
        this.nameField.requestFocusInWindow();
        this.nameField.setText(this.currentNode.getAlgorithmName());
        this.nameField.selectAll();
    }

    private void changesName(DesktopComponentDialog dialog) {
        String text = this.nameField.getText();
        if (text == null) {
            return;
        }
        String trimmedText = text.trim();
        if (trimmedText.isEmpty()) {
            return;
        }
        this.currentNode.setNewTitle(trimmedText);
        this.currentNode.repaint();
        dialog.close();
    }

    public static WorkspaceFilter createFilter(final Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("O par\u00e2metro workspace est\u00e1 nulo.");
        }
        return new AddNodePopupActionFilter(workspace){

            @Override
            protected Action createAction(GraphNode graphNode, Point2D point) {
                return new LabelAction(graphNode, workspace);
            }
        };
    }
}

