/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.view.simple.SimpleAlgorithmConfiguratorPanel;
import csbase.logic.algorithms.parameters.Parameter;

/**
 * Representa uma fbrica da viso de um tipo de parmetro do sistema que pode
 * ser carregada dinamicamente.
 */
public interface ParameterViewFactory {

  /**
   * Cria uma instncia da viso a partir do parmetro.
   * 
   * @param configurationPanel Painel onde a viso ser criada.
   * @param parameter O parmetro.
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}
   * @return uma instncia da viso do parmetro.
   */
  ParameterView<?> create(SimpleAlgorithmConfiguratorPanel configurationPanel,
    Parameter<?> parameter, ParameterView.Mode mode);
}
