package csbase.client.remote.srvproxies;

import java.awt.Window;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe que modela um proxy no cliente para o para acesso s operaes
 * disponibilizadas pelo servio de aplicaes (ApplicationService).
 */
public class ApplicationManagementProxy {

  /**
   * Aplica a recarga dos algoritmos no servidor.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos
   * @return retorna true se a recarga foi feita com sucesso, caso contrrio,
   *         retorna false
   */
  public static boolean reloadApplications(Window owner) {
    RemoteTask<Boolean> task = new RemoteTask<Boolean>() {
      @Override
      public void performTask() throws Exception {
        setResult(ClientRemoteLocator.applicationService.reloadApplications());
      }
    };
    String suffix = ApplicationManagementProxy.class.getSimpleName();
    if ((task.execute(owner, LNG.get(suffix + ".applications.title.reloading"),
      LNG.get(suffix + ".applications.msg.reloading"))) && (task.getResult())) {
      return true;
    }
    return false;
  }

}
