package csbase.client.util.gui.log.actions.core;

import javax.swing.ImageIcon;

import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanel.FileEvent;

/**
 * Representa uma ao do painel de log que necessite que exista um arquivo.
 * Sendo assim, esta ao altera seu estado para habilitada ou desabilitada
 * sempre que um arquivo de log  aberto ou fechado no painel, respectivamente.
 * 
 * @author Tecgraf / PUC-Rio
 */
public abstract class AbstractLogFileAction extends AbstractLogAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   * @param icon imagem da ao.
   */
  protected AbstractLogFileAction(final LogPanel logPanel, final ImageIcon icon) {
    super(logPanel, icon);
    setInitialState(logPanel);
    createStateManager(logPanel);
  }

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  protected AbstractLogFileAction(final LogPanel logPanel) {
    super(logPanel);
    setInitialState(logPanel);
    createStateManager(logPanel);
  }

  /**
   * Incializao do estado da ao.
   * 
   * @param logPanel o painel de log
   */
  private void setInitialState(final LogPanel logPanel) {
    setEnabled(null != logPanel.getFile());
  }

  /**
   * Colocao de listeners de eventos.
   * 
   * @param logPanel o painel de log
   */
  private void createStateManager(final LogPanel logPanel) {
    logPanel.addFileEventListener(new EventListener<LogPanel.FileEvent>() {
      public void eventFired(FileEvent event) {
        if (LogPanel.FileEvent.Type.CLOSED == event.getType()) {
          setEnabled(false);
        }
        else if (LogPanel.FileEvent.Type.OPENED == event.getType()) {
          setEnabled(true);
        }
      }
    });
  }
}
