/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.queuepanel;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.ClearEndedAction;
import csbase.client.applications.filetransferclient.actions.RefreshQueueTableAction;
import csbase.client.applications.filetransferclient.actions.RequestInterruptAction;
import csbase.client.applications.filetransferclient.actions.RequestRemoveAction;
import csbase.client.applications.filetransferclient.panels.core.FileTransferClientPanel;
import csbase.client.applications.filetransferclient.panels.queuepanel.QueueRenderer;
import csbase.client.applications.filetransferclient.panels.queuepanel.QueueTableModel;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.table.SortableTable;

public class FileTransferClientQueuePanel
extends FileTransferClientPanel {
    private final SortableTable table = new SortableTable();

    private JToolBar createTableToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FileTransferClient app = this.getApplication();
        toolbar.add(new RefreshQueueTableAction(app));
        toolbar.add(new ClearEndedAction(app));
        toolbar.addSeparator();
        toolbar.add(new RequestInterruptAction(app));
        toolbar.add(new RequestRemoveAction(app));
        return toolbar;
    }

    private void mountPanel() {
        String[] colNames = new String[]{this.getString("column.status"), this.getString("column.type"), this.getString("column.user"), this.getString("column.percentage"), this.getString("column.file"), this.getString("column.size"), this.getString("column.global.rate"), this.getString("column.queue.time"), this.getString("column.start.time"), this.getString("column.end.time"), this.getString("column.error.message")};
        QueueTableModel model = new QueueTableModel(colNames);
        this.table.setModel((TableModel)model);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new QueueRenderer());
        this.table.setSelectionMode(2);
        this.table.setNoSortStateEnabled(true);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel columnModel = this.table.getColumnModel();
        int W = 50;
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(50);
        columnModel.getColumn(2).setPreferredWidth(150);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(4).setPreferredWidth(200);
        columnModel.getColumn(5).setPreferredWidth(100);
        columnModel.getColumn(6).setPreferredWidth(50);
        columnModel.getColumn(7).setPreferredWidth(150);
        columnModel.getColumn(8).setPreferredWidth(150);
        columnModel.getColumn(9).setPreferredWidth(150);
        columnModel.getColumn(10).setPreferredWidth(250);
        JToolBar toolbar = this.createTableToolbar();
        this.setLayout(new BorderLayout());
        this.table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add((Component)scrollPane, "Center");
        this.add((Component)toolbar, "West");
        BorderUtil.setLowBorder((JComponent)this);
    }

    public FileTransferClientQueuePanel(FileTransferClient application) {
        super(application);
        this.mountPanel();
    }

    public void refresh() {
        FileTransferClient app = this.getApplication();
        FileTransferProxy serviceProxy = app.getServiceProxy();
        User user = null;
        User loggedUser = User.getLoggedUser();
        if (!loggedUser.getId().equals(User.getAdminId())) {
            user = loggedUser;
        }
        List<FileTransferRequest> list = serviceProxy.getAllRequests(user);
        QueueTableModel model = (QueueTableModel)this.table.getModel();
        int[] sels = this.table.getSelectedRows();
        model.setRequestList(list);
        for (int sel : sels) {
            int nrows = this.table.getRowCount();
            if (sel >= nrows) continue;
            this.table.addRowSelectionInterval(sel, sel);
        }
    }

    public List<String> getSelectedRequestsIds() {
        int[] sels = this.table.getSelectedRows();
        ArrayList<String> ids = new ArrayList<String>();
        if (sels == null || sels.length == 0) {
            return ids;
        }
        QueueTableModel model = (QueueTableModel)this.table.getModel();
        List<FileTransferRequest> modelList = model.getRequestList();
        for (int sel : sels) {
            int modelSel = this.table.convertRowIndexToModel(sel);
            FileTransferRequest req = modelList.get(modelSel);
            ids.add(req.getId());
        }
        Collections.unmodifiableList(ids);
        return ids;
    }

    public List<FileTransferRequest> getAllRequests() {
        QueueTableModel model = (QueueTableModel)this.table.getModel();
        return model.getRequestList();
    }
}

