/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.event;

import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventObserver;
import csbase.client.util.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class EventManager {
    private List<EventObserver<?>> observers = new ArrayList();
    private Observable eventNotifier = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public synchronized <E extends IEvent, L extends EventListener<E>> void addEventListener(L listener, Class<E> clazz) {
        EventObserver<E> observer = new EventObserver<E>(listener, clazz);
        this.observers.add(observer);
        this.eventNotifier.addObserver(observer);
    }

    public synchronized <E extends IEvent> void removeEventListeners(Class<E> clazz) {
        for (EventObserver<?> observer : this.observers) {
            if (!clazz.isAssignableFrom(observer.clazz)) continue;
            this.observers.remove(observer);
            this.eventNotifier.deleteObserver(observer);
        }
    }

    public synchronized <E extends IEvent, L extends EventListener<E>> void removeEventListener(L listener) {
        for (EventObserver<?> observer : this.observers) {
            if (!observer.listener.equals(listener)) continue;
            this.observers.remove(observer);
            this.eventNotifier.deleteObserver(observer);
            return;
        }
    }

    public void fireEvent(IEvent event) {
        this.eventNotifier.notifyObservers(event);
    }

    public int countListeners() {
        return this.eventNotifier.countObservers();
    }
}

