/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.Client;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.EventLogProxy;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerURI;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class ClientRemoteMonitorListener
implements MonitoredServerListener {
    private final Window parent;
    private static JOptionPane messagePane = null;
    private static JDialog dialog;
    private static String[] desktopQueue;

    public ClientRemoteMonitorListener(Window parent) {
        this.parent = parent;
        if (messagePane == null) {
            messagePane = new JOptionPane();
        }
    }

    public void notifyConnectionLost(final ServerURI serverURI) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String serverName = serverURI.getHost();
                String msg = String.format(LNG.get((String)"ClientRemoteMonitorListener.connection.lost"), serverName, FormatUtils.format((Date)new Date()));
                String title = String.format(LNG.get((String)"ClientRemoteMonitorListener.connection.lost.title"), serverName);
                messagePane.setMessage(msg);
                messagePane.setMessageType(0);
                ClientRemoteMonitorListener.this.buildDialog(title);
            }
        });
    }

    public void notifyConnectionReestablished(final ServerURI serverURI) {
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String title;
                String serverVersion;
                ClientRemoteMonitor monitor = ClientRemoteMonitor.getInstance();
                String serverName = serverURI.getHost();
                try {
                    serverVersion = monitor.getServer().getVersionName();
                }
                catch (RemoteException e) {
                    serverVersion = "??.??.??";
                }
                String clientVersion = Client.getInstance().getVersion();
                if (serverVersion.equals(clientVersion)) {
                    EventLogProxy.addClientInformation(desktopQueue, LNG.get((String)"ClientRemoteMonitorListener.connection.reestablished.log"));
                    String msg = String.format(LNG.get((String)"ClientRemoteMonitorListener.connection.reestablished"), serverName, FormatUtils.format((Date)new Date()));
                    title = String.format(LNG.get((String)"ClientRemoteMonitorListener.connection.reestablished.title"), serverName);
                    messagePane.setMessage(msg);
                    messagePane.setMessageType(1);
                } else {
                    EventLogProxy.addClientInformation(desktopQueue, LNG.get((String)"ClientRemoteMonitorListener.different.version.log"));
                    String msg = String.format(LNG.get((String)"ClientRemoteMonitorListener.different.version"), serverName, FormatUtils.format((Date)new Date()));
                    title = String.format(LNG.get((String)"ClientRemoteMonitorListener.different.version.title"), serverName);
                    messagePane.setMessage(msg);
                    messagePane.setMessageType(0);
                }
                ClientRemoteMonitorListener.this.buildDialog(title);
            }
        });
    }

    private void buildDialog(String title) {
        if (dialog == null) {
            dialog = messagePane.createDialog(this.parent, title);
        } else {
            dialog.setTitle(title);
            dialog.repaint();
        }
        dialog.pack();
        dialog.setVisible(true);
    }

    public void notifyLoggedIn(ServerURI serverURI) {
    }

    public void notifyLoggedOut(ServerURI serverURI) {
    }

    static {
        desktopQueue = new String[]{"ConnectionMonitoring"};
    }
}

