package csbase.client.applications.algorithmsmanager.report.core;

import java.util.ArrayList;
import java.util.List;

/**
 * Implementao padro do resultado
 * 
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> Tipo do resultado.
 */
public class TestResult<T> implements ITestResult<T> {

  /** Lista de mensagens */
  private List<IResultMessage<T>> messages = new ArrayList<>();

  /**
   * Contrutor vazio
   * 
   */
  public TestResult() {

  }

  /**
   * Contrutor com lista de mensagens
   * 
   * @param messages Lista de mensagens.
   */
  public TestResult(List<IResultMessage<T>> messages) {
    this.messages = messages;

  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<T>> getMessages() {
    return messages;
  }

  /**
   * Adiciona uma mensagem ao resultado
   *
   * @param message A mensagem.
   */
  public void addMessage(IResultMessage<T> message) {
    messages.add(message);
  }

  /**
   * Adiciona mensagens ao resultado
   *
   * @param messages Lista de mensagens.
   */
  public void addMessages(List<IResultMessage<T>> messages) {
    this.messages.addAll(messages);
  }
}
