package csbase.client.desktop;

import csbase.logic.CommandNotification;

/**
 * Listener para notificaes de comandos finalizados. So cadastrados no
 * <code>CommandNotificationHandler</code>.
 */
public interface CommandListener {

  /**
   * Notifica o trmino da execuo do comando. Pode ter terminado normalmente,
   * pode ter ocorrido falha, pode ter sido cancelado ou pode ter sido perdido.
   * Ou seja, <code>CommandNotificationData</code> pode ser instncia de:
   * <code>CommandEndNotificationData</code>, ou
   * <code>CommandFailedNotificationData</code>, ou
   * <code>CommandKilledNotificationData</code>, ou
   * <code>CommandLostNotificationData</code>.
   * 
   * @param data o dado de notificao.
   */
  public void notifyCommand(CommandNotification data);

  /**
   * Indica se o listener deve ser removido do
   * <code>CommandNotificationHandler</code> aps a notificao.
   * 
   * @return true se o listener deve ser removido aps a notificao, ou false
   *         caso contrrio.
   */
  public boolean shouldRemove();

}
