/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskinfo;

import csbase.client.applications.Application;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;

public class DiskUserTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[3];
    private int rowAmount;
    private Object[][] formattedData;

    public DiskUserTableModel(Application app, Hashtable<Object, Double> usersData) {
        this.columnNames[0] = app.getString("tableFrame.columUser");
        this.columnNames[1] = app.getString("tableFrame.columAmount");
        this.columnNames[2] = app.getString("tableFrame.columPercentage");
        this.formattedData = this.getFormattedData(usersData);
    }

    @Override
    public int getRowCount() {
        return this.rowAmount;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return c == 0 ? String.class : Double.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.formattedData[rowIndex][columnIndex];
    }

    private Object[][] getFormattedData(Hashtable<Object, Double> usersData) {
        Object[][] data = null;
        DecimalFormat formatter = new DecimalFormat("##0.##");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        formatter.setDecimalFormatSymbols(dfs);
        Enumeration<Object> userIds = usersData.keys();
        Double totalAmount = 0.0;
        ArrayList<ArrayList> userDataList = new ArrayList<ArrayList>();
        while (userIds.hasMoreElements()) {
            String userId = (String)userIds.nextElement();
            Double amount = usersData.get(userId);
            totalAmount = totalAmount + amount;
            ArrayList userRecord = new ArrayList();
            userRecord.add(userId);
            userRecord.add(new Double(formatter.format(amount)));
            userDataList.add(userRecord);
        }
        this.rowAmount = userDataList.size();
        data = new Object[this.rowAmount][3];
        int i = 0;
        for (ArrayList userRecord : userDataList) {
            Double userPercentage = (Double)userRecord.get(1) / totalAmount * 100.0;
            userRecord.add(new Double(formatter.format(userPercentage)));
            data[i++] = userRecord.toArray();
        }
        return data;
    }
}

