/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommandStatus;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class RemoveProjectTask
extends ProjectsManagerTask<Boolean> {
    private List<ProjectsManagerData> projects;

    public RemoveProjectTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects) {
        super(projectsManager);
        this.projects = projects;
    }

    protected void performTask() {
        boolean res = true;
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        CommandPersistenceServiceInterface cpsi = ClientRemoteLocator.commandPersistenceService;
        try {
            for (ProjectsManagerData prj : this.projects) {
                Set runningCommands = cpsi.getStatusCommandInfos(prj.getProjectId(), Arrays.asList(CommandStatus.FINISHED), false);
                if (runningCommands.size() > 0) {
                    this.cancelTask();
                    res = false;
                    break;
                }
                psi.removeProject(prj.getProjectId());
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
            res = false;
        }
        this.setResult(res);
    }
}

