/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao para remover uma plataforma.
 */
public class RemovePlatform extends AbstractVersionTreeNodeAction {

  // Verso que detm a plataforma a ser removida.
  private AlgorithmVersionInfo version;
  // Nome da plataforma a ser removida.
  private String platformName;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso que detm a plataforma.
   * @param platformName Nome da plataforma a ser removida.
   */
  public RemovePlatform(VersionTree tree, AlgorithmVersionInfo version,
    String platformName) {
    super(tree, LNG.get("algomanager.menu.platform.remove"));

    this.version = version;
    this.platformName = platformName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    new RemovePlatformDialog().showRemove();
  }

  /**
   * Classe que representa um dilogo de remoo de plataformas.
   * 
   * @author Leonardo Barros
   */
  private class RemovePlatformDialog {

    /**
     * Mostra um dilogo de remoo de plataforma.
     * 
     * @return true se a plataforma tiver sido removida com sucesso.
     */
    public boolean showRemove() {
      String removeTitle =
        MessageFormat.format(LNG.get("algomanager.title.remove_platform"),
          new Object[] { version.getInfo().getName(), version.getId() });
      Object[] options =
        { LNG.get("algomanager.button.remove"),
            LNG.get("algomanager.button.cancel") };
      int opt =
        StandardDialogs.showOptionDialog(getWindow(), removeTitle,
          MessageFormat.format(
            LNG.get("algomanager.msg.confirm.platform_remove"),
            new Object[] { platformName }), options);
      if (opt != 0) {
        return false;
      }
      AlgorithmInfo algo =
        AlgorithmManagementProxy.removePlatform(version.getInfo().getId(),
          version.getId(), platformName, getWindow());
      if (algo == null) {
        StandardErrorDialogs.showErrorDialog(getWindow(),
          LNG.get("algomanager.title.error") + " - " + removeTitle,
          MessageFormat.format(LNG.get("algomanager.error.platform_remove"),
            new Object[] { platformName }));
        return false;
      }
      return true;
    }
  }
}
