/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.models;

/**
 * Informaes de uma expresso que possa ser utilizada por um filtro.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ExpressionDTO {

  /** Linguagem padro a ser utilizada caso nenhuma seja fornecida. */
  private static final String DEFAULT_LANGUAGE = "JavaScript";

  /** Linguagem na qual foi escrita a expresso. */
  private final String language;
  /** Valor da expresso - script. */
  private final String value;

  /**
   * Construtor.
   * 
   * @param language Linguagem na qual foi escrita a expresso.
   * @param value Valor da expresso - script.
   */
  public ExpressionDTO(String language, String value) {
    this.language = language;
    this.value = value;
  }

  /**
   * Obtm a linguagem padro.
   * 
   * @return a linguagem padro.
   */
  public static String getDefaultLanguage() {
    return DEFAULT_LANGUAGE;
  }

  /**
   * Obtm a linguagem na qual foi escrita a expresso.
   * 
   * @return Linguagem na qual foi escrita a expresso.
   */
  public String getLanguage() {
    return language;
  }

  /**
   * Obtm o valor da expresso - script.
   * 
   * @return Valor da expresso - script.
   */
  public String getValue() {
    return value;
  }
}
