package csbase.client.applications.flowapplication.filters;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.AskForParameterValuesAction;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;

/**
 * Filtro Vix para solicitar valores dos parmetros do configurador de
 * algoritmos de um n.
 */
public final class AskForParameterValuesActionFilter extends WorkspaceFilter {
  /**
   * A ao que solicita valores.
   */
  private AskForParameterValuesAction parameterAction;

  /**
   * Cria um filtro.
   *
   * @param action A ao que solicita valores.
   * @param workspace A rea de trabalho.
   */
  public AskForParameterValuesActionFilter(
    final AskForParameterValuesAction action, final Workspace workspace) {
    this(workspace);
    setAction(action);
  }

  /**
   * Cria um filtro.
   *
   * @param workspace A rea de trabalho.
   */
  public AskForParameterValuesActionFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackButton(final Point2D pt, final MouseEvent ev) {
    if ((ev.getButton() == MouseEvent.BUTTON1
      && ev.getID() == MouseEvent.MOUSE_CLICKED && ev.getClickCount() == 2)
      || (ev.getButton() == MouseEvent.BUTTON2 && ev.getID() == MouseEvent.MOUSE_CLICKED)) {
      final PickNodeMessage pickNodeMessage = new PickNodeMessage(pt);
      pickNodeMessage.sendVO(this);
      final GraphNode node = pickNodeMessage.getNode();
      if (node != null) {
        if (node.getAlgorithmConfiguratorView() != null) {
          node.askForParameterValues();
        }
        else {
          node.showError();
        }
      }
    }
    super.callbackButton(pt, ev);
  }

  /**
   * Obtm a ao que solicita os valores.
   *
   * @return A ao que solicita os valores.
   */
  public AskForParameterValuesAction getAction() {
    return this.parameterAction;
  }

  /**
   * Atribui a ao que solicita os valores a esta instncia.
   *
   * @param action A ao que solicita os valores.
   */
  private void setAction(final AskForParameterValuesAction action) {
    if (action == null) {
      throw new IllegalArgumentException("O parmetro action est nulo.");
    }
    this.parameterAction = action;
    this.parameterAction.setEnabled(false);
  }
}
