package csbase.client.project.action;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import csbase.client.project.ClientProjectFileType;
import csbase.logic.ProjectFileType;

/**
 * Renderizador para a combobox de tipo de arquivo.
 *
 */
public class ProjectFileTypeComboBoxRenderer implements
  ListCellRenderer<Object> {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getListCellRendererComponent(JList<?> list, Object value,
    int index, boolean isSelected, boolean cellHasFocus) {

    ProjectFileType type = null;
    type = (ProjectFileType) value;

    ClientProjectFileType c = ClientProjectFileType.getFileType(type.getCode());
    Icon icon = c.getBaseIcon();

    JLabel renderer = new JLabel();
    renderer.setText(type.getDescription());
    renderer.setIcon(icon);

    return renderer;
  }

}
