/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applications.Application;
import csbase.client.desktop.DesktopErrorEvent;
import csbase.client.desktop.DesktopFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ApplicationComponentFrame
extends JDialog {
    private Application application = null;
    private JPanel frameContents;
    private JLabel statusBar;

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.application.addWindow(this);
        } else {
            this.application.removeWindow(this);
        }
    }

    public void center() {
        this.center(this.application.getApplicationFrame());
    }

    public void center(Window window) {
        Dimension sSize = window.getSize();
        Dimension wSize = this.getSize();
        int newX = (sSize.width - wSize.width) / 2;
        int newY = (sSize.height - wSize.height) / 2;
        this.setLocation(window.getX() + newX, window.getY() + newY);
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    public Container getContentPane() {
        return this.frameContents;
    }

    public void showStatusBar() {
        if (this.statusBar.getText() == null || this.statusBar.getText().trim().equals("")) {
            this.statusBar.setText(" ");
        }
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public void signalError(DesktopErrorEvent errorEvent) {
        if (errorEvent.errorMessage != null) {
            DesktopFrame dktFrame = DesktopFrame.getInstance();
            Image img = null;
            if (dktFrame != null) {
                img = dktFrame.getDesktopErrorImage();
            }
            if (this.statusBar != null) {
                if (img != null) {
                    this.statusBar.setIcon(new ImageIcon(img));
                }
                this.statusBar.setText(errorEvent.errorMessage);
            }
        }
    }

    public void resetError(DesktopErrorEvent errorEvent) {
        if (errorEvent.errorMessage != null) {
            this.statusBar.setIcon(null);
            this.statusBar.setText("");
        }
    }

    public ApplicationComponentFrame(Application application) {
        this(null, application);
    }

    public ApplicationComponentFrame(String title, Application application) {
        super((Frame)application.getApplicationFrame(), title == null ? application.getName() : title);
        this.application = application;
        this.frameContents = new JPanel(new BorderLayout());
        this.statusBar = new JLabel();
        this.statusBar.setHorizontalAlignment(2);
        Container cp = super.getContentPane();
        cp.add((Component)this.frameContents, "Center");
        cp.add((Component)this.statusBar, "South");
    }
}

