/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.applications.flowapplication.CategoryTreeNode;
import csbase.client.applications.flowapplication.NodeCallback;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.tree.Node;

public class TreeUtil {
    private static final NodeCallback collapseCallback = new NodeCallback(){

        @Override
        public void postProcess(JTree t, TreePath parentPath, Node node) {
            TreePath path = parentPath == null ? new TreePath(node) : parentPath.pathByAddingChild(node);
            t.collapsePath(path);
        }
    };

    public static void _collapseAll(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtil.doAll(tree, new TreePath(root), false);
    }

    private static void doAll(JTree tree, TreePath parentPath, boolean expand) {
        TreeNode node = (TreeNode)parentPath.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parentPath.pathByAddingChild(n);
                TreeUtil.doAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parentPath);
        } else {
            tree.collapsePath(parentPath);
        }
    }

    public static void collapsedAll(JTree tree) {
        TreeUtil.processNodes(tree, collapseCallback);
    }

    private static TreePath hasObject(JTree tree, TreePath parentPath, Node node, Object object) {
        if (node.equals(object) && node.getParent().equals(((Node)object).getParent())) {
            return parentPath.pathByAddingChild(node);
        }
        TreePath path = parentPath.pathByAddingChild(node);
        for (Node childNode : node.getChildren()) {
            TreePath tpath = TreeUtil.hasObject(tree, path, childNode, object);
            if (tpath == null) continue;
            return tpath;
        }
        return null;
    }

    private static TreePath hasRootObject(JTree tree, Object object) {
        TreeModel model = tree.getModel();
        Node root = (Node)model.getRoot();
        TreePath rootPath = new TreePath(root);
        if (root.equals(object)) {
            return new TreePath(root);
        }
        for (Node node : root.getChildren()) {
            TreePath tpath = TreeUtil.hasObject(tree, rootPath, node, object);
            if (tpath == null) continue;
            return tpath;
        }
        return null;
    }

    public static void loadExpanded(JTree tree, List<Node> nodes) {
        for (Node node : nodes) {
            TreePath path = TreeUtil.hasRootObject(tree, node);
            if (path == null) continue;
            tree.expandPath(path);
        }
    }

    public static void loadCollapsed(JTree tree, List<Node> nodes) {
        for (Node node : nodes) {
            TreePath path = TreeUtil.hasRootObject(tree, node);
            if (path == null) continue;
            tree.collapsePath(path);
        }
    }

    public static void openRootNode(final JTree tree) {
        NodeCallback callback = new NodeCallback(){

            @Override
            public final void postProcess(JTree t, TreePath parentPath, Node node) {
                Node root = (Node)tree.getModel().getRoot();
                if (parentPath == null) {
                    TreePath rootPath = new TreePath(root);
                    tree.expandPath(rootPath);
                }
            }
        };
        TreeUtil.processNodes(tree, callback);
    }

    public static void openCategoryTreeNode(final JTree tree) {
        NodeCallback callback = new NodeCallback(){

            @Override
            public final void postProcess(JTree t, TreePath parentPath, Node node) {
                Node root = (Node)tree.getModel().getRoot();
                if (node instanceof CategoryTreeNode) {
                    if (parentPath == null) {
                        TreePath rootPath = new TreePath(root);
                        tree.expandPath(rootPath);
                    } else {
                        TreePath path = parentPath.pathByAddingChild(node);
                        tree.expandPath(path);
                    }
                }
            }
        };
        TreeUtil.processNodes(tree, callback);
    }

    public static void processNodes(JTree tree, NodeCallback callback) {
        Node root = (Node)tree.getModel().getRoot();
        TreePath rootPath = new TreePath(root);
        callback.preProcess(tree, null, root);
        if (root.getChildren().size() >= 0) {
            Iterator iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                Node e;
                Node node = e = (Node)iterator.next();
                TreeUtil.visitNodes(tree, rootPath, node, callback);
            }
        }
        callback.postProcess(tree, null, root);
    }

    static List<Node> saveExpanded(JTree tree) {
        final ArrayList<Node> list = new ArrayList<Node>();
        NodeCallback callback = new NodeCallback(){

            @Override
            public final void postProcess(JTree t, TreePath parentPath, Node node) {
                TreePath path = parentPath == null ? new TreePath(node) : parentPath.pathByAddingChild(node);
                if (t.isExpanded(path)) {
                    list.add(node);
                }
            }
        };
        TreeUtil.processNodes(tree, callback);
        return list;
    }

    public static List<Node> saveCollapsed(JTree tree) {
        final ArrayList<Node> list = new ArrayList<Node>();
        NodeCallback callback = new NodeCallback(){

            @Override
            public final void postProcess(JTree t, TreePath parentPath, Node node) {
                TreePath path = parentPath == null ? new TreePath(node) : parentPath.pathByAddingChild(node);
                if (t.isCollapsed(path)) {
                    list.add(node);
                }
            }
        };
        TreeUtil.processNodes(tree, callback);
        return list;
    }

    private static void visitNodes(JTree tree, TreePath parentPath, Node node, NodeCallback callback) {
        callback.preProcess(tree, parentPath, node);
        TreePath path = parentPath.pathByAddingChild(node);
        if (node.getChildren().size() >= 0) {
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                Node e;
                Node childNode = e = (Node)iterator.next();
                TreeUtil.visitNodes(tree, path, childNode, callback);
            }
        }
        callback.postProcess(tree, parentPath, node);
    }
}

