/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.zoom;

import csbase.client.applications.flowapplication.zoom.ZoomListener;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AbstractZoomModel
implements ZoomModel {
    private final double maxValue;
    private final double standardValue;
    private final double minValue;
    private final double blockIncrement;
    private final double unitIncrement;
    private final Collection<ZoomListener> listenerCollection;

    public AbstractZoomModel(double minValue, double maxValue, double defaultValue, double unitIncrement, double blockIncrement) {
        if (minValue <= 0.0) {
            throw new IllegalArgumentException("minValue <= 0.0");
        }
        if (maxValue <= 0.0) {
            throw new IllegalArgumentException("maxValue <= 0.0");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue > maxValue");
        }
        if (defaultValue > maxValue) {
            throw new IllegalArgumentException("defaultValue > maxValue");
        }
        if (defaultValue < minValue) {
            throw new IllegalArgumentException("defaultValue < minValue");
        }
        if (unitIncrement <= 0.0) {
            throw new IllegalArgumentException("unitIncrement <= 0.0");
        }
        if (blockIncrement <= 0.0) {
            throw new IllegalArgumentException("blockIncrement <= 0.0");
        }
        if (unitIncrement > blockIncrement) {
            throw new IllegalArgumentException("unitIncrement > blockIncrement");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.standardValue = defaultValue;
        this.blockIncrement = blockIncrement;
        this.unitIncrement = unitIncrement;
        this.listenerCollection = new LinkedList<ZoomListener>();
    }

    @Override
    public void addListener(ZoomListener listener) {
        this.listenerCollection.add(listener);
    }

    @Override
    public boolean hasNextBlockValue() {
        return this.getValue() < this.getMaxValue();
    }

    @Override
    public boolean hasPreviousBlockValue() {
        return this.getValue() > this.getMinValue();
    }

    @Override
    public boolean hasNextUnitValue() {
        return this.getValue() < this.getMaxValue();
    }

    @Override
    public boolean hasPreviousUnitValue() {
        return this.getValue() > this.getMinValue();
    }

    @Override
    public void removeListener(ZoomListener listener) {
        this.listenerCollection.remove(listener);
    }

    @Override
    public final double getBlockIncrement() {
        return this.blockIncrement;
    }

    @Override
    public final double getUnitIncrement() {
        return this.unitIncrement;
    }

    @Override
    public final double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public final double getMinValue() {
        return this.minValue;
    }

    @Override
    public final double getStandardValue() {
        return this.standardValue;
    }

    @Override
    public final double getNextUnitValue() {
        double nextValue = this.getValue() + this.getUnitIncrement();
        if (nextValue > this.maxValue) {
            nextValue = this.maxValue;
        }
        return nextValue;
    }

    @Override
    public final double getPreviousUnitValue() {
        double previousValue = this.getValue() - this.getUnitIncrement();
        if (previousValue < this.minValue) {
            previousValue = this.minValue;
        }
        return previousValue;
    }

    @Override
    public final double getNextBlockValue() {
        double nextValue = this.getValue() + this.getBlockIncrement();
        if (nextValue > this.maxValue) {
            nextValue = this.maxValue;
        }
        return nextValue;
    }

    @Override
    public final double getPreviousBlockValue() {
        double previousValue = this.getValue() - this.getBlockIncrement();
        if (previousValue < this.minValue) {
            previousValue = this.minValue;
        }
        return previousValue;
    }

    @Override
    public final void setValue(double newValue) {
        double value = newValue;
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        this.changeValue(value);
        for (ZoomListener listener : this.listenerCollection) {
            listener.wasChanged(this);
        }
    }

    protected abstract void changeValue(double var1);
}

