package csbase.client.algorithms.commands.view;

import java.awt.GridBagLayout;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.view.simple.SimpleAlgorithmConfiguratorPanel;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;

/**
 * Dilogo de visualizao de comandos simples.
 * 
 * @author Tecgraf / PUC-Rio
 */
class SimpleAlgorithmCommandView extends AbstractAlgorithmCommandView {

  /**
   * Construtor
   * 
   * @param index identificador da view. Usado para garantir a unicidade.
   * @param owner A janela pai deste dilogo (No aceita {@code null}).
   * @param command O comando (No aceita {@code null}).
   * @param configurator O configurador a ter seus parmetros apresentados.
   *        Deve-se ignorar o configurador do comando pois pode ser diferente
   *        deste. Isso ocorrerira no caso de estar representando um n de um
   *        comando de fluxo (No aceita {@code null}).
   * @param viewType Tipo de log a ser mostrado nessa viso do comando (No
   *        aceita {@code null}).
   * @param nodeId Identificador do algoritmo (caso seja n de um fluxo).
   * 
   * @throws ClientException Erro ao obter informaes sobre o comando.
   */
  public SimpleAlgorithmCommandView(final Object index,
    final DesktopComponentFrame owner, final CommandInfo command,
    final AlgorithmConfigurator configurator, final CommandViewType viewType,
    final Integer nodeId) throws ClientException {
    super(index, owner, command, configurator, viewType, nodeId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ConfigurationReportTab createConfigurationReportTab(
    final AlgorithmConfigurator configurator) throws ClientException {
    return new ParametersTab(configurator);
  }

  /**
   * Tab para visualizar os parmetros do comando. Contm um painel do tipo
   * {@link SimpleAlgorithmConfiguratorPanel}.
   */
  protected final class ParametersTab extends ConfigurationReportTab {

    /**
     * Ttulo.
     */
    private final String title;

    /**
     * Construtor
     * 
     * @param configurator configurador
     * @throws ClientException se houver problemas na criao do configurador.
     */
    ParametersTab(final AlgorithmConfigurator configurator)
      throws ClientException {
      super();

      String algorithmName, algorithmVersion;
      if (null == configurator) {
        algorithmName = "";
        algorithmVersion = "";
      }
      else {
        algorithmName = configurator.getAlgorithmName();
        algorithmVersion = configurator.getAlgorithmVersion().toString();

        this.setLayout(new GridBagLayout());

        AlgorithmConfiguratorFactory configuratorFactory =
          AlgorithmConfiguratorFactory.getInstance();
        AlgorithmConfiguratorView view =
          configuratorFactory.createReportView(owner, configurator);
        if (view != null) {
          this.add(view.getMainComponent(), new GBC(0, 0).both());
        }
      }

      this.title =
        String.format(
          LNG.get(SimpleAlgorithmCommandView.class.getSimpleName()
            + ".tab.params.title.template"), algorithmName, algorithmVersion);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getTitle() {
      return title;
    }
  }
}
